/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views.jsp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.struts2.components.Head;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;


/**
 * @see Head
 */
@SuppressWarnings("serial")
public class HeadTag extends ComponentTagSupport {

	// attributes
	protected String locale;
	protected String contentType;
	protected String charset;
	protected String bom;
	protected String contentDisposition;
	protected String filename;
	protected String noCache;

	/**
	 * @param cache the cache to set
	 */
	public void setNoCache(String cache) {
		this.noCache = cache;
	}

	/**
	 * @param contentType the contentType to set
	 */
	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	/**
	 * @param charset the charset to set
	 */
	public void setCharset(String charset) {
		this.charset = charset;
	}

	/**
	 * @param bom the bom to set
	 */
	public void setBom(String bom) {
		this.bom = bom;
	}

	/**
	 * @param contentDisposition the contentDisposition to set
	 */
	public void setContentDisposition(String contentDisposition) {
		this.contentDisposition = contentDisposition;
	}

	/**
	 * @param filename the filename to set
	 */
	public void setFilename(String filename) {
		this.filename = filename;
	}

	/**
	 * @param locale the locale to set
	 */
	public void setLocale(String locale) {
		this.locale = locale;
	}

	/**
	 * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	public Component getBean(ValueStack stack, HttpServletRequest req,
		HttpServletResponse res) {
		return new Head(stack, req, res);
	}

	/**
	 * @see org.apache.struts2.views.jsp.ui.AbstractUITag#populateParams()
	 */
	protected void populateParams() {
		super.populateParams();

		Head head = ((Head)component);

		head.setLocale(locale);
		head.setContentType(contentType);
		head.setCharset(charset);
		head.setBom(bom);
		head.setContentDisposition(contentDisposition);
		head.setFilename(filename);
		head.setNoCache(noCache);
	}

}
