/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views.freemarker.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.struts2.components.CDate;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.freemarker.tags.TagModel;


import com.opensymphony.xwork2.util.ValueStack;


/**
 * @see CDate
 */
public class DateModel extends TagModel {
    /**
     * Constructor
     * 
     * @param stack ValueStack 
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     */
    public DateModel(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack, req, res);
    }

    protected Component getBean() {
        return new CDate(stack);
    }
}
