/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views.freemarker;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.struts2.util.StrutsContextUtils;

import org.apache.struts2.views.freemarker.FreemarkerManager;

import com.opensymphony.xwork2.util.ValueStack;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;

/**
 * FreemarkerUtils
 */
public class FreemarkerUtils {
	/**
	 * @return FreemarkerManager
	 */
	public static FreemarkerManager getFreemarkerManager() {
		return StrutsContextUtils.getContainer().getInstance(FreemarkerManager.class);
	}

	/**
	 * hasTemplate
	 * @param name template name
	 * @return true if template exists
	 * @throws TemplateException if template exception occurs
	 */
	public static boolean hasTemplate(String name) throws TemplateException {
        ServletContext servletContext = StrutsContextUtils.getServletContext();
        Locale locale = StrutsContextUtils.getLocale();

        FreemarkerManager freemarkerManager = getFreemarkerManager();

		Configuration configuration = (Configuration)freemarkerManager.getConfiguration(servletContext);
		
        try {
			configuration.getTemplate(name, locale);
			return true;
		}
		catch (IOException e) {
			return false;
		}
	}
	
	/**
	 * process template
	 * @param name template name
	 * @param writer writer
	 * @throws TemplateException if a template error occurs
	 * @throws IOException if an I/O error occurs
	 */
	public static void processTemplate(String name, Writer writer) throws TemplateException, IOException {
        ServletContext servletContext = StrutsContextUtils.getServletContext();
        HttpServletRequest request = StrutsContextUtils.getServletRequest();
        HttpServletResponse response = StrutsContextUtils.getServletResponse();
        ValueStack stack = StrutsContextUtils.getValueStack();
        Locale locale = StrutsContextUtils.getLocale();
        Object action = StrutsContextUtils.getAction();
		FreemarkerManager freemarkerManager = getFreemarkerManager();

		Configuration configuration = (Configuration)freemarkerManager.getConfiguration(servletContext);

        TemplateModel model = getFreemarkerManager().buildTemplateModel(stack, action, servletContext, request, response, configuration.getObjectWrapper());
        Template template = configuration.getTemplate(name, locale);

        template.process(model, writer);
	}
	
	/**
	 * process template
	 * @param name template name
	 * @return result
	 * @throws TemplateException if a template error occurs
	 * @throws IOException if an I/O error occurs
	 */
	public static String processTemplate(String name) throws TemplateException, IOException {
        StringWriter sw = new StringWriter();
        processTemplate(name, sw);
        return sw.toString();
	}
}
