/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views.freemarker;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import nuts.ext.struts2.util.StrutsContextUtils;

import org.apache.struts2.views.freemarker.FreemarkerResult;

import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;

import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateModel;

/**
 * FreemarkerDecorateResult
 */
@SuppressWarnings("serial")
public class FreemarkerDecorateResult extends FreemarkerResult {

	/**
	 * Constructor 
	 */
	public FreemarkerDecorateResult() {
		super();
	}

	/**
	 * Constructor
	 * @param location location
	 */
	public FreemarkerDecorateResult(String location) {
		super(location);
	}

	/**
	 * @see org.apache.struts2.views.freemarker.FreemarkerResult#preTemplateProcess(freemarker.template.Template, freemarker.template.TemplateModel)
	 */
	@Override
	protected boolean preTemplateProcess(Template template, TemplateModel model) throws IOException {
		if (model instanceof SimpleHash) {
			SimpleHash hash = (SimpleHash)model;
			
			HttpServletRequest req = StrutsContextUtils.getServletRequest();
			
			// populate the hash with the page
			hash.put("base", req.getContextPath());
			
			Page page = (Page)req.getAttribute(RequestConstants.PAGE);
			if (page != null) {
				hash.put("page", page);
				if (page instanceof HTMLPage) {
					HTMLPage htmlPage = ((HTMLPage) page);
					hash.put("head", htmlPage.getHead());
				}
				hash.put("title", page.getTitle());
				hash.put("body", page.getBody());
				hash.put("page.properties", new SimpleHash(page.getProperties()));
			}
		}

		return super.preTemplateProcess(template, model);
	}
}
