/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.views;

import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.struts2.views.freemarker.tags.NutsModels;
import nuts.ext.struts2.views.velocity.components.ActionConfirmDirective;
import nuts.ext.struts2.views.velocity.components.ActionErrorDirective;
import nuts.ext.struts2.views.velocity.components.ActionMessageDirective;
import nuts.ext.struts2.views.velocity.components.ActionWarningDirective;
import nuts.ext.struts2.views.velocity.components.BooleanDirective;
import nuts.ext.struts2.views.velocity.components.CheckBoxDirective;
import nuts.ext.struts2.views.velocity.components.CheckBoxListDirective;
import nuts.ext.struts2.views.velocity.components.CsvDirective;
import nuts.ext.struts2.views.velocity.components.DateDirective;
import nuts.ext.struts2.views.velocity.components.DatePickerDirective;
import nuts.ext.struts2.views.velocity.components.DateTimePickerDirective;
import nuts.ext.struts2.views.velocity.components.FieldErrorDirective;
import nuts.ext.struts2.views.velocity.components.FileDirective;
import nuts.ext.struts2.views.velocity.components.FormDirective;
import nuts.ext.struts2.views.velocity.components.HeadDirective;
import nuts.ext.struts2.views.velocity.components.HiddenDirective;
import nuts.ext.struts2.views.velocity.components.LinkDirective;
import nuts.ext.struts2.views.velocity.components.ListViewDirective;
import nuts.ext.struts2.views.velocity.components.LogDirective;
import nuts.ext.struts2.views.velocity.components.NumberDirective;
import nuts.ext.struts2.views.velocity.components.PagerDirective;
import nuts.ext.struts2.views.velocity.components.PasswordDirective;
import nuts.ext.struts2.views.velocity.components.PropertyDirective;
import nuts.ext.struts2.views.velocity.components.RadioDirective;
import nuts.ext.struts2.views.velocity.components.ResetDirective;
import nuts.ext.struts2.views.velocity.components.SelectDirective;
import nuts.ext.struts2.views.velocity.components.SubmitDirective;
import nuts.ext.struts2.views.velocity.components.TextAreaDirective;
import nuts.ext.struts2.views.velocity.components.TextDirective;
import nuts.ext.struts2.views.velocity.components.TextFieldDirective;
import nuts.ext.struts2.views.velocity.components.TimePickerDirective;
import nuts.ext.struts2.views.velocity.components.TriggerFieldDirective;
import nuts.ext.struts2.views.velocity.components.UploadDirective;
import nuts.ext.struts2.views.velocity.components.ViewFieldDirective;

import org.apache.struts2.views.TagLibrary;
import org.apache.struts2.views.velocity.components.URLDirective;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * NutsTagLibrary
 */
public class NutsTagLibrary implements TagLibrary {

	/**
	 * @see org.apache.struts2.views.TagLibrary#getFreemarkerModels(com.opensymphony.xwork2.util.ValueStack, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public Object getFreemarkerModels(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new NutsModels(stack, req, res);
	}

	/**
	 * @see org.apache.struts2.views.TagLibrary#getVelocityDirectiveClasses()
	 */
	public List<Class> getVelocityDirectiveClasses() {
		Class[] directives = new Class[] {
			ActionErrorDirective.class,
			ActionWarningDirective.class,
			ActionConfirmDirective.class,
			ActionMessageDirective.class,
			BooleanDirective.class,
			CheckBoxDirective.class,
			CheckBoxListDirective.class,
			CsvDirective.class,
			DateDirective.class,
			DatePickerDirective.class,
			DateTimePickerDirective.class,
			FieldErrorDirective.class,
			FileDirective.class,
			FormDirective.class,
			HeadDirective.class,
			HiddenDirective.class,
			LinkDirective.class,
			ListViewDirective.class,
			LogDirective.class,
			NumberDirective.class,
			PagerDirective.class,
			PasswordDirective.class,
			PropertyDirective.class,
			RadioDirective.class,
			ResetDirective.class,
			SelectDirective.class,
			SubmitDirective.class,
			TextDirective.class,
			TextAreaDirective.class,
			TextFieldDirective.class,
			TimePickerDirective.class,
			TriggerFieldDirective.class,
			UploadDirective.class,
			URLDirective.class,
			ViewFieldDirective.class
		};
		return Arrays.asList(directives);
	}
}
