/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.util;

import java.util.Locale;
import java.util.Map;

import nuts.ext.xwork2.ActionSupport;
import nuts.ext.xwork2.util.ContextUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 */
public class ActionHelper {

	protected static Log log = LogFactory.getLog(ActionHelper.class);

	/**
	 * Constructor
	 */
	public ActionHelper() {
	}

	public ActionSupport getAction() {
		return (ActionSupport)ContextUtils.getAction();
	}
	
	/**
	 * @return session
	 */
	public Map<String, Object> getSession() {
		return ContextUtils.getSession();
	}
	
	/**
	 * @return application
	 */
	public Map<String, Object> getApplication() {
		return ContextUtils.getApplication();
	}
	
	/**
	 * @return locale
	 */
	public Locale getLocale() {
		return ContextUtils.getLocale();
	}
	
	/**
	 * @return namespace
	 */
	public String getNamespace() {
		return ContextUtils.getNamespace();
	}
}
