/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc --> Render an HTML input field of type text</p> <!-- END SNIPPET:
 * javadoc -->
 * <p/>
 * <b>Examples</b>
 * <p/>
 * <!-- START SNIPPET: exdescription --> In this example, a text control for the "user" property is
 * rendered. The label is also retrieved from a ResourceBundle via the key attribute. <!-- END
 * SNIPPET: exdescription -->
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;r:viewfield key=&quot;user&quot; /&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example2 --&gt;
 * &lt;r:viewfield name=&quot;user&quot; label=&quot;User Name&quot; /&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 */
@StrutsTag(
		name = "viewfield", 
		tldTagClass = "nuts.ext.struts2.views.jsp.ui.ViewFieldTag", 
		description = "Render an HTML span & hidden field of type text", 
		allowDynamicAttributes = true)
public class ViewField extends ListUIBean {
	/**
	 * The name of the default template for the ViewFieldTag
	 */
	final public static String TEMPLATE = "n-viewfield";

	protected String expression;
	protected String format;
	protected String iconClass;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public ViewField(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	@SuppressWarnings("unchecked")
	protected Class getValueClassType() {
		return null;
	}

	/**
	 * evaluate extra parameters
	 */
	public void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (format != null) {
			addParameter("format", findString(format));
		}

		if (expression != null) {
			addParameter("expression", findString(expression));
		}

		if (iconClass != null) {
			addParameter("iconClass", findString(iconClass));
		}
	}

	/**
	 * @param expression the expression to set
	 */
	@StrutsTagAttribute(description = "the expression to set")
	public void setExpression(String expression) {
		this.expression = expression;
	}

	/**
	 * @param format the format to set
	 */
	@StrutsTagAttribute(description = "the format to set")
	public void setFormat(String format) {
		this.format = format;
	}

	/**
	 * @param iconClass the iconClass to set
	 */
	@StrutsTagAttribute(description = "the iconClass to set")
	public void setIconClass(String iconClass) {
		this.iconClass = iconClass;
	}
}
