/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.TextField;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * <!-- START SNIPPET: javadoc --> Render an HTML input tag of type password.</p> <!-- END SNIPPET:
 * javadoc -->
 * <p/>
 * <b>Examples</b>
 * <p/>
 * <!-- START SNIPPET: exdescription --> In this example, a password control is displayed. For the
 * label, we are calling ActionSupport's getText() to retrieve password label from a resource
 * bundle.
 * <p/>
 * <!-- END SNIPPET: exdescription -->
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;s:password label=&quot;%{text('password')}&quot; name=&quot;password&quot; size=&quot;10&quot; maxlength=&quot;15&quot; /&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 */
@StrutsTag(
		name = "password", 
		tldTagClass = "nuts.ext.struts2.views.jsp.ui.PasswordTag", 
		description = "Render an HTML input tag of type password", 
		allowDynamicAttributes = true)
public class Password extends TextField {
	private final static String TEMPLATE = "n-password";

	protected String showPassword;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public Password(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	/**
	 * evaluate extra parameters
	 */
	public void evaluateExtraParams() {
		super.evaluateExtraParams();

		if (showPassword != null) {
			addParameter("showPassword", findValue(showPassword, Boolean.class));
		}
	}

	/**
	 * @param showPassword the showPassword to set
	 */
	@StrutsTagAttribute(description = "Whether to show input", type = "Boolean", defaultValue = "false")
	public void setShowPassword(String showPassword) {
		this.showPassword = showPassword;
	}

}
