/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.components;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.ext.xwork2.TextProvider;
import nuts.ext.xwork2.util.ContextUtils;

import org.apache.struts2.components.Form;
import org.apache.struts2.components.UIBean;
import org.apache.struts2.util.ContainUtil;
import org.apache.struts2.util.MakeIterator;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * Render an HTML List View.
 */
@SuppressWarnings("unchecked")
@StrutsTag(
	name = "listview", 
	tldTagClass = "nuts.ext.struts2.views.jsp.ui.ListViewTag", 
	description = "Renders a list view", 
	allowDynamicAttributes = true)
public class ListView extends UIBean {

	/**
	 * DEFAULT_THRESHOLD = 10;
	 */
	public final static int DEFAULT_THRESHOLD = 10;

	protected final static String TEMPLATE = "n-listview";

	// attributes
	protected Object list;
	protected Object columns;
	protected Object querys;

	protected String start;
	protected String limit;
	protected String total;
	protected String sort;
	protected String dir;
	protected String query;

	protected String cssColumn;
	protected String action;
	protected String method;
	protected String onsubmit;
	protected String onreset;

	protected String pager;
	protected String extra;

	protected Object link;
	protected Object toolbar;

	protected String singleSelect;
	protected String toggleSelect;
	protected String onrowclick;

	protected String enableValues;
	
	private static int sequence = 0;

	private Map boolFilterMap;
	private Map dateFilterMap;
	private Map stringFilterMap;
	private Map numberFilterMap;
	private Map searchKindMap;
	
	/**
	 * @see UIBean
	 * @param stack value stack
	 * @param request http servlet request
	 * @param response http servlet response
	 */
	public ListView(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	/**
	 * getTextAsMap
	 * @param name resource name
	 * @return map value
	 */
	private Map getTextAsMap(String name) {
		ValueStack stack = getStack();
		TextProvider tp = ContextUtils.findValueInStack(stack, TextProvider.class);
		return tp.getTextAsMap(name, Collections.EMPTY_MAP);
	}

	/**
	 * @return the searchKindMap
	 */
	public Map getSearchKindMap() {
		if (searchKindMap == null) {
			searchKindMap = getTextAsMap("listview-search-kind");
		}
		return searchKindMap;
	}

	/**
	 * @return the boolFilterMap
	 */
	public Map getBoolFilterMap() {
		if (boolFilterMap == null) {
			boolFilterMap = getTextAsMap("listview-filter-bool");
		}
		return boolFilterMap;
	}

	/**
	 * @return the dateFilterMap
	 */
	public Map getDateFilterMap() {
		if (dateFilterMap == null) {
			dateFilterMap = getTextAsMap("listview-filter-date");
		}
		return dateFilterMap;
	}

	/**
	 * @return the numberFilterMap
	 */
	public Map getNumberFilterMap() {
		if (numberFilterMap == null) {
			numberFilterMap = getTextAsMap("listview-filter-number");
		}
		return numberFilterMap;
	}

	/**
	 * @return the stringFilterMap
	 */
	public Map getStringFilterMap() {
		if (stringFilterMap == null) {
			stringFilterMap = getTextAsMap("listview-filter-string");
		}
		return stringFilterMap;
	}

	/**
	 * @return default template
	 */
	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	
	/**
	 * Override UIBean's implementation, such that component Html id is determined in the following
	 * order :-
	 * <ol>
	 * <li>This component id attribute</li>
	 * <li>list_[an increasing sequential number]</li>
	 * </ol>
	 * 
	 * @param form form
	 */
	protected void populateComponentHtmlId(Form form) {
		String tryId;
		if (id != null) {
			// this check is needed for backwards compatibility with 2.1.x
			tryId = findStringIfAltSyntax(id);
		}
		else {
			tryId = "list_" + (sequence++);
		}
		addParameter("id", tryId);
	}

	/**
	 * Evaluate extra parameters
	 */
	protected void evaluateExtraParams() {
		super.evaluateExtraParams();

		Object value;

		// list
		if (list == null) {
			list = parameters.get("list");
		}

		value = null;
		if (list instanceof String) {
			if (!getParameters().containsKey("listName")) {
				addParameter("listName", list);
			}
			value = findValue((String) list);
		}
		else if (MakeIterator.isIterable(list)) {
			value = list;
		}
		addParameter("list", value);

		if (value instanceof Collection) {
			addParameter("listSize", new Integer(((Collection) value).size()));
		}
		else if (value instanceof Map) {
			addParameter("listSize", new Integer(((Map) value).size()));
		}
		else if (value != null && value.getClass().isArray()) {
			addParameter("listSize", new Integer(Array.getLength(value)));
		}
		else {
			addParameter("listSize", 0);
		}

		// columns
		if (columns == null) {
			columns = parameters.get("columns");
		}

		value = null;
		if (columns instanceof String) {
			value = findValue((String) columns);
		}
		else if (MakeIterator.isIterable(columns)) {
			value = columns;
		}

		if (value == null) {
			fieldError(
				"columns",
				"The requested columns '"
						+ columns
						+ "' could not be resolved as a collection/array/map/enumeration/iterator type.",
				null);
		}
		else {
			addParameter("columns", value);
		}

		// querys
		if (querys == null) {
			querys = parameters.get("querys");
		}

		if (querys instanceof String) {
			value = findValue((String)querys);
		}
		else {
			value = querys;
		}
		
		if (value instanceof Map) {
			addParameter("querys", value);
		}
		else if (querys != null) {
			fieldError(
				"querys",
				"The requested querys '"
						+ querys
						+ "' could not be resolved as a map type.",
				null);
		}

		// toolbar
		if (toolbar == null) {
			toolbar = parameters.get("toolbar");
		}

		value = null;
		if (toolbar instanceof String) {
			value = findValue((String) toolbar, "toolbar", "The requested toolbar key '" + toolbar
					+ "' could not be resolved as a map type.");
		}
		else if (toolbar instanceof Map) {
			value = toolbar;
		}
		else if (toolbar != null) {
			fieldError(
				"toolbar",
				"The requested toolbar '"
						+ toolbar
						+ "' could not be resolved as a map type.",
				null);
		}

		if (value == null) {
			Map<String, Object> m = new HashMap<String, Object>();
			m.put("head", DEFAULT_THRESHOLD);
			m.put("foot", true);
			addParameter("toolbar", m);
		}
		else {
			addParameter("toolbar", value);
		}

		// link
		if (link == null) {
			link = parameters.get("link");
		}

		value = null;
		if (link instanceof String) {
			value = findValue((String) link);
		}
		else {
			value = link;
		}
		addParameter("link", value);

		// other
		if (start != null) {
			addParameter("start", findString(start));
		}
		if (limit != null) {
			addParameter("limit", findString(limit));
		}
		if (total != null) {
			addParameter("total", findString(total));
		}
		if (sort != null) {
			addParameter("sort", findString(sort));
		}
		if (dir != null) {
			addParameter("dir", findString(dir));
		}
		if (query != null) {
			addParameter("query", findString(query));
		}
		if (cssColumn != null) {
			addParameter("cssColumn", findString(cssColumn));
		}
		if (action != null) {
			addParameter("action", findString(action));
		}
		if (method != null) {
			addParameter("method", findString(method));
		}
		if (onsubmit != null) {
			addParameter("onsubmit", findString(onsubmit));
		}
		if (onreset != null) {
			addParameter("onreset", findString(onreset));
		}
		if (pager != null) {
			addParameter("pager", findValue(pager, Boolean.class));
		}
		if (extra != null) {
			addParameter("extra", findString(extra));
		}
		if (singleSelect != null) {
			addParameter("singleSelect", findValue(singleSelect, Boolean.class));
		}
		if (toggleSelect != null) {
			addParameter("toggleSelect", findValue(toggleSelect, Boolean.class));
		}
		if (onrowclick != null) {
			addParameter("onrowclick", findString(onrowclick));
		}
		if (enableValues != null) {
			addParameter("enableValues", findValue(enableValues, Boolean.class));
		}
	}

	/**
	 * @param obj1 object 1
	 * @param obj2 object 2
	 * @return true if obj2 exists in obj1
	 */
	public boolean contains(Object obj1, Object obj2) {
		return ContainUtil.contains(obj1, obj2);
	}

	/**
	 * @param list the list to set
	 */
	@StrutsTagAttribute(description = "the property for the list")
	public void setList(Object list) {
		this.list = list;
	}

	/**
	 * @param columns the columns to set
	 */
	@StrutsTagAttribute(description = "the property for the columns")
	public void setColumns(Object columns) {
		this.columns = columns;
	}

	/**
	 * @param querys the querys to set
	 */
	@StrutsTagAttribute(description = "the property for the querys")
	public void setQuerys(Object querys) {
		this.querys = querys;
	}

	/**
	 * @param start the start to set
	 */
	@StrutsTagAttribute(description = "the property for the start")
	public void setStart(String start) {
		this.start = start;
	}

	/**
	 * @param limit the limit to set
	 */
	@StrutsTagAttribute(description = "the property for the pager size")
	public void setLimit(String limit) {
		this.limit = limit;
	}

	/**
	 * @param total the total to set
	 */
	@StrutsTagAttribute(description = "the property for the total size")
	public void setTotal(String total) {
		this.total = total;
	}

	/**
	 * @param sort the sort to set
	 */
	@StrutsTagAttribute(description = "the property for the sort")
	public void setSort(String sort) {
		this.sort = sort;
	}

	/**
	 * @param dir the dir to set
	 */
	@StrutsTagAttribute(description = "the property for the sort dir")
	public void setDir(String dir) {
		this.dir = dir;
	}

	/**
	 * @param query the query to set
	 */
	@StrutsTagAttribute(description = "the property for the query")
	public void setQuery(String query) {
		this.query = query;
	}

	/**
	 * @param link the link to set
	 */
	@StrutsTagAttribute(description = "the property for the link")
	public void setLink(Object link) {
		this.link = link;
	}

	/**
	 * @param cssColumn the cssColumn to set
	 */
	@StrutsTagAttribute(description = "the property for the cssColumn")
	public void setCssColumn(String cssColumn) {
		this.cssColumn = cssColumn;
	}

	/**
	 * @param action the action to set
	 */
	@StrutsTagAttribute(description = "the property for the action")
	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @param method the method to set
	 */
	@StrutsTagAttribute(description = "the property for the method")
	public void setMethod(String method) {
		this.method = method;
	}

	/**
	 * @param onsubmit the onsubmit to set
	 */
	@StrutsTagAttribute(description = "the property for the onsubmit")
	public void setOnsubmit(String onsubmit) {
		this.onsubmit = onsubmit;
	}

	/**
	 * @param onreset the onreset to set
	 */
	@StrutsTagAttribute(description = "the property for the onreset")
	public void setOnreset(String onreset) {
		this.onreset = onreset;
	}

	/**
	 * @param toolbar the toolbar to set
	 */
	@StrutsTagAttribute(description = "the property for the toolbar")
	public void setToolbar(Object toolbar) {
		this.toolbar = toolbar;
	}

	/**
	 * @param pager the pager to set
	 */
	@StrutsTagAttribute(description = "the property for the pager")
	public void setPager(String pager) {
		this.pager = pager;
	}

	/**
	 * @param extra the extra to set
	 */
	@StrutsTagAttribute(description = "the property for the extra")
	public void setExtra(String extra) {
		this.extra = extra;
	}

	/**
	 * @param singleSelect the singleSelect to set
	 */
	@StrutsTagAttribute(description = "the property for the singleSelect")
	public void setSingleSelect(String singleSelect) {
		this.singleSelect = singleSelect;
	}

	/**
	 * @param toggleSelect the toggleSelect to set
	 */
	@StrutsTagAttribute(description = "the property for the toggleSelect")
	public void setToggleSelect(String toggleSelect) {
		this.toggleSelect = toggleSelect;
	}

	/**
	 * @param onrowclick the onrowclick to set
	 */
	@StrutsTagAttribute(description = "the property for the onrowclick")
	public void setOnrowclick(String onrowclick) {
		this.onrowclick = onrowclick;
	}

	/**
	 * @param enableValues the enableValues to set
	 */
	@StrutsTagAttribute(description = "the property for the enableValues")
	public void setEnableValues(String enableValues) {
		this.enableValues = enableValues;
	}
}
