/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.actions;

import nuts.core.lang.StringUtils;
import nuts.ext.xwork2.util.ContextUtils;

import com.opensymphony.xwork2.util.ValueStack;

/**
 */
@SuppressWarnings("serial")
public class OgnlEvaluateAction extends CommonAction {

	private String ognl;
	private Object value;

	/**
	 * @return the ognl
	 */
	public String getOgnl() {
		return ognl;
	}

	/**
	 * @param ognl the ognl to set
	 */
	public void setOgnl(String ognl) {
		this.ognl = ognl;
	}

	/**
	 * @return the value
	 */
	public Object getValue() {
		return value;
	}

	/**
	 * @param value the value to set
	 */
	public void setValue(Object value) {
		this.value = value;
	}

	/**
	 * execute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		if (StringUtils.isNotBlank(ognl)) {
			ValueStack vs = ContextUtils.getValueStack();
			value = vs.findValue(ognl);
			return SUCCESS;
		}
		else {
			return INPUT;
		}
	}
}
