/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.actions;

/**
 */
public interface NutsTextConstants {
	//------------------------------------------------------------
	// LIST SETTINGS
	//------------------------------------------------------------
	/**
	 * LIST_SORTER_COLUMN = "list-sorter-column";
	 */
	public final static String LIST_SORTER_COLUMN = "list-sorter-column";
	
	/**
	 * DEFAULT_LIST_SORTER_DIRECTION = "list-sorter-direction";
	 */
	public final static String LIST_SORTER_DIRECTION = "list-sorter-direction";

	/**
	 * LIST_PAGER_LIMIT = "list-pager-limit";
	 */
	public final static String LIST_PAGER_LIMIT = "list-pager-limit";
	
	/**
	 * PAGER_MAX_LIMIT = "pager-max-limit";
	 */
	public final static String PAGER_MAX_LIMIT = "pager-max-limit";
	
	/**
	 * POPUP_PAGER_LIMIT = "popup-pager-limit";
	 */
	public final static String POPUP_PAGER_LIMIT = "popup-pager-limit";
	
	/**
	 * DEFAULT_POPUP_PAGER_LIMIT = 10;
	 */
	public final static int DEFAULT_POPUP_PAGER_LIMIT = 10;
	
	//------------------------------------------------------------
	// ACTION MESSAGE PREFIX
	//------------------------------------------------------------
	/**
	 * ACCESS_SUCCESS_PREFIX = "action-success-";
	 */
	public final static String ACCESS_SUCCESS_PREFIX = "action-success-";
	
	/**
	 * ACTION_CONFIRM_PREFIX = "action-confirm-";
	 */
	public final static String ACTION_CONFIRM_PREFIX = "action-confirm-";
	
	/**
	 * ACTION_FAILED_PREFIX = "action-failed-";
	 */
	public final static String ACTION_FAILED_PREFIX = "action-failed-";
	
	//------------------------------------------------------------
	// CONFIRM MESSAGES
	//------------------------------------------------------------
	/**
	 * CONFIRM_DATA_OVERWRITE = "confirm-data-overwrite";
	 */
	public final static String CONFIRM_DATA_OVERWRITE = "confirm-data-overwrite";
	
	//------------------------------------------------------------
	// ERROR MESSAGES
	//------------------------------------------------------------
	/**
	 * ERROR_DATA_NOTFOUND = "error-data-notfound";
	 */
	public final static String ERROR_DATA_NOTFOUND = "error-data-notfound";
	
	/**
	 * ERROR_DATA_LIST_EMPTY = "error-data-list-empty";
	 */
	public final static String ERROR_DATA_LIST_EMPTY = "error-data-list-empty";
	
	/**
	 * ERROR_DATA_DUPLICATE = "error-data-duplicate";
	 */
	public final static String ERROR_DATA_DUPLICATE = "error-data-duplicate";
	
	/**
	 * ERROR_FIELDVALUE_NOTNULL = "error-fieldvalue-notnull";
	 */
	public final static String ERROR_FIELDVALUE_NOTNULL = "error-fieldvalue-notnull";
	
	/**
	 * ERROR_FIELDVALUE_REQUIRED = "error-fieldvalue-required";
	 */
	public final static String ERROR_FIELDVALUE_REQUIRED = "error-fieldvalue-required";
	
	/**
	 * ERROR_FIELDVALUE_INCORRECT = "error-fieldvalue-incorrect";
	 */
	public final static String ERROR_FIELDVALUE_INCORRECT = "error-fieldvalue-incorrect";
	
	/**
	 * ERROR_FIELDVALUE_DUPLICATE = "error-fieldvalue-duplicate";
	 */
	public final static String ERROR_FIELDVALUE_DUPLICATE = "error-fieldvalue-duplicate";
	
	/**
	 * ERROR_FILE_NOTFOUND = "error-file-notfound";
	 */
	public final static String ERROR_FILE_NOTFOUND = "error-file-notfound";
}
