/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.actions;

import java.util.List;

import nuts.ext.vfs.ndfs.dao.NdfsFile;
import nuts.ext.vfs.ndfs.dao.NdfsFileExample;

/**
 */
@SuppressWarnings("serial")
public class NdfsFileAction extends ModelDrivenAction<NdfsFile, NdfsFileExample> {
	/**
	 * Constructor
	 */
	public NdfsFileAction() {
	}

	/**
	 * @return the NdfsFile
	 */
	public NdfsFile getD() {
		return this.data;
	}

	/**
	 * @param NdfsFile the NdfsFile to set
	 */
	public void setD(NdfsFile NdfsFile) {
		this.data = NdfsFile;
	}

	/**
	 * @return the NdfsFile list
	 */
	public List<NdfsFile> getDl() {
		return this.dataList;
	}

	/**
	 * @param NdfsFileList the NdfsFileList to set
	 */
	public void setDl(List<NdfsFile> NdfsFileList) {
		this.dataList = NdfsFileList;
	}

	/**
	 * prepareDefaultData
	 * @param data data
	 * @return data
	 */
	protected NdfsFile prepareDefaultData(NdfsFile data) throws Exception {
		if (data == null) {
			data = new NdfsFile();
		}
		return data;
	}

	/**
	 * list
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String list() throws Exception {
		if (get_save() == null) {
			set_save(true);
		}
		return doList();
	}
	
	/**
	 * listCsv
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String listCsv() throws Exception {
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * listPrint
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String listPrint() throws Exception {
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * listPopup
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String listPopup() throws Exception {
		if (pager.getLimit() == null) {
			pager.setLimit(getTextAsInt(POPUP_PAGER_LIMIT, DEFAULT_POPUP_PAGER_LIMIT));
		}
		if (get_save() == null) {
			set_save(false);
		}
		return doList();
	}
	
	/**
	 * bdeleteConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdeleteConfirm() throws Exception {
		return doBatchDeleteConfirm();
	}

	/**
	 * bdeleteExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String bdeleteExecute() throws Exception {
		return doBatchDeleteExecute();
	}
	
	/**
	 * selectInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String selectInput() throws Exception {
		return doSelectInput();
	}

	/**
	 * selectExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String selectExecute() throws Exception {
		return doSelectExecute();
	}

	/**
	 * selectPrint
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String selectPrint() throws Exception {
		return doSelectPrint();
	}

	/**
	 * insertSelect
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertSelect() throws Exception {
		return doInsertSelect();
	}

	/**
	 * insertInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertInput() throws Exception {
		return doInsertInput();
	}

	/**
	 * insertConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertConfirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * insertExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String insertExecute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * copySelect
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copySelect() throws Exception {
		return doInsertSelect();
	}

	/**
	 * copyInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyInput() throws Exception {
		return doInsertInput();
	}

	/**
	 * copyConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyConfirm() throws Exception {
		return doInsertConfirm();
	}

	/**
	 * copyExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String copyExecute() throws Exception {
		return doInsertExecute();
	}

	/**
	 * updateSelect
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateSelect() throws Exception {
		return doUpdateSelect();
	}

	/**
	 * updateInput
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateInput() throws Exception {
		return doUpdateInput();
	}

	/**
	 * updateConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateConfirm() throws Exception {
		return doUpdateConfirm();
	}

	/**
	 * updateExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String updateExecute() throws Exception {
		return doUpdateExecute();
	}

	/**
	 * deleteConfirm
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String deleteConfirm() throws Exception {
		return doDeleteConfirm();
	}

	/**
	 * deleteExecute
	 * @return SUCCESS
	 * @throws Exception if an error occurs
	 */
	public String deleteExecute() throws Exception {
		return doDeleteExecute();
	}

}