/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.io.IOUtils;
import nuts.core.servlet.HttpServletUtils;
import nuts.ext.fileupload.UploadFile;

import org.apache.commons.vfs.FileContent;

/**
 * File download/upload for temporary image
 */
@SuppressWarnings("serial")
public class FileServeAction extends CommonServletAction {

	protected UploadFile file = new UploadFile();

	protected boolean cache = true;
	protected int bufferSize = 4096;
	protected String contentDisposition;


	/**
	 * @return the file
	 */
	public UploadFile getFile() {
		return file;
	}

	/**
	 * @param file the file to set
	 */
	public void setFile(UploadFile file) {
		this.file = file;
	}

	/**
	 * @return the cache
	 */
	public boolean isCache() {
		return cache;
	}

	/**
	 * @param cache the cache to set
	 */
	public void setCache(boolean cache) {
		this.cache = cache;
	}

	/**
	 * @return the bufferSize
	 */
	public int getBufferSize() {
		return bufferSize;
	}

	/**
	 * @param bufferSize the bufferSize to set
	 */
	public void setBufferSize(int bufferSize) {
		this.bufferSize = bufferSize;
	}

	/**
	 * @return the contentDisposition
	 */
	public String getContentDisposition() {
		return contentDisposition;
	}

	/**
	 * @param contentDisposition the contentDisposition to set
	 */
	public void setContentDisposition(String contentDisposition) {
		this.contentDisposition = contentDisposition;
	}

	/**
	 * @return the filename
	 * @throws IOException IOException
	 */
	public String getFn() throws IOException {
		return file.getSaveName();
	}

	/**
	 * @param filename the filename to set
	 * @throws IOException IOException
	 */
	public void setFn(String filename) throws IOException {
		file.setSaveName(filename);
	}

	/**
	 * execute
	 * 
	 * @return result name
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return SUCCESS;
	}
	
	/**
	 * upload
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String upload() throws Exception {
		return SUCCESS;
	}
	
	/**
	 * download
	 * 
	 * @return NONE
	 * @throws Exception if an error occurs
	 */
	public String download() throws Exception {
		if (file.getFile() == null) {
			return NONE;
		}

		InputStream is = null;
		OutputStream os = null;

		try {
			HttpServletRequest servletRequest = getServletRequest();
			HttpServletResponse servletResponse = getServletResponse();

			FileContent fc = file.getFile().getContent();
			String filename = file.getFile().getName().getBaseName();
			
			// set http header
			Map<String, Object> header = new HashMap<String, Object>();
			header.put("contentType", IOUtils.getContentTypeFor(filename));
			header.put("contentLength", Long.valueOf(fc.getSize()));
			header.put("contentDisposition", contentDisposition);
			header.put("filename", HttpServletUtils.EncodeFileName(servletRequest, filename));
			header.put("cache", cache);

			HttpServletUtils.setResponseHeader(servletResponse, header);

			// Get the outputstream
			os = servletResponse.getOutputStream();

			is = fc.getInputStream();

			// Copy input to output
			byte[] buf = new byte[bufferSize];
			int sz;
			while (-1 != (sz = is.read(buf))) {
				os.write(buf, 0, sz);
			}

			// Flush
			os.flush();
		}
		finally {
			IOUtils.closeQuietly(is);
			IOUtils.closeQuietly(os);
		}
		
		return NONE;
	}

}
