/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.struts2;

/**
 * This class provides a central location for framework configuration keys
 * used to retrieve and store Struts configuration settings.
 */
public class NutsStrutsConstants {

	/** The utils of action */
	public static final String NUTS_ACTION_UTILS = "nuts.action.utils";

	/** The constants of action */
	public static final String NUTS_ACTION_CONST = "nuts.action.const";

	/** The default includeParams method to generate Struts URLs */
	public static final String NUTS_URL_INCLUDEPARAMS = "nuts.url.includeParams";

	/** The default escapeAmp method to generate Struts URLs */
	public static final String NUTS_URL_ESCAPEAMP = "nuts.url.escapeAmp";

	/** The defaults of datepicker */
	public static final String NUTS_DATEPICKER_DEFAULTS = "nuts.datepicker.defaults";
	
	/** The defaults of timepicker */
	public static final String NUTS_TIMEPICKER_DEFAULTS = "nuts.timepicker.defaults";
	
	/** The defaults of datetimepicker */
	public static final String NUTS_DATETIMEPICKER_DEFAULTS = "nuts.datetimepicker.defaults";
	
    /** The maximize size of a multipart request (file upload) */
    public static final String NUTS_MULTIPART_MAXSIZE = "nuts.multipart.maxSize";

    /** The directory to use for storing uploaded files */
    public static final String NUTS_MULTIPART_SAVEDIR = "nuts.multipart.saveDir";

	/**
	 * NUTS_MOCKACTION = "nuts.mockAction";
	 */
	public static final String NUTS_MOCKACTION = "nuts.mockAction";
}
