/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.ext.sitemesh;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.PageParserSelector;
import com.opensymphony.sitemesh.ContentProcessor;
import com.opensymphony.sitemesh.webapp.SiteMeshWebAppContext;

public class ContentBufferingResponse extends HttpServletResponseWrapper {

	// TODO: Temporary SM3 migration implementation! Wraps SM2
	// PageResponseWrapper. This class is an evil stopgap.
	// Eventually PageResponseWrapper will go away and the functionality will be
	// rolled into this class.

	private final PageResponseWrapper pageResponseWrapper;

	public ContentBufferingResponse(HttpServletResponse response,
			final ContentProcessor contentProcessor,
			final SiteMeshWebAppContext webAppContext) {
		super(new PageResponseWrapper(response, new PageParserSelector() {
			public boolean shouldParsePage(String contentType) {
				return contentProcessor.handles(contentType);
			}

			public PageParser getPageParser(String contentType) {
				// Migration: Not actually needed by PageResponseWrapper, so
				// long as getPage() isn't called.
				return null;
			}
		}) {
			public void setContentType(String contentType) {
				webAppContext.setContentType(contentType);
				super.setContentType(contentType);
			}
		});
		pageResponseWrapper = (PageResponseWrapper)getResponse();
	}

	/**
	 * @return the pageResponseWrapper
	 */
	public PageResponseWrapper getPageResponseWrapper() {
		return pageResponseWrapper;
	}
}
