/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs.ndfs.dao;

import java.io.Serializable;
import java.util.Date;

/**
 */
@SuppressWarnings("serial")
public class NdfsFile implements Serializable {
	/*----------------------------------------------------------------------*
	 * Properties
	 *----------------------------------------------------------------------*/
	protected Long id;
	protected Long parentId = 0L;
	protected String name;
	protected Boolean folder;
	protected Long length = 0L;
	protected Date lastModified;
	protected Boolean hidden = false;
	protected Boolean readable = true;
	protected Boolean writeable = true;
	protected byte[] data;

	/**
	 * Constructor
	 */
	public NdfsFile() {
		super();
	}

	/**
	 * @return the id
	 */
	public Long getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the parentId
	 */
	public Long getParentId() {
		return parentId;
	}

	/**
	 * @param parentId the parentId to set
	 */
	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the folder
	 */
	public Boolean getFolder() {
		return folder;
	}

	/**
	 * @param folder the folder to set
	 */
	public void setFolder(Boolean folder) {
		this.folder = folder;
	}

	/**
	 * @return the hidden
	 */
	public Boolean getHidden() {
		return hidden;
	}

	/**
	 * @param hidden the hidden to set
	 */
	public void setHidden(Boolean hidden) {
		this.hidden = hidden;
	}

	/**
	 * @return the readable
	 */
	public Boolean getReadable() {
		return readable;
	}

	/**
	 * @param readable the readable to set
	 */
	public void setReadable(Boolean readable) {
		this.readable = readable;
	}

	/**
	 * @return the writeable
	 */
	public Boolean getWriteable() {
		return writeable;
	}

	/**
	 * @param writeable the writeable to set
	 */
	public void setWriteable(Boolean writeable) {
		this.writeable = writeable;
	}

	/**
	 * @return the length
	 */
	public Long getLength() {
		return length;
	}

	/**
	 * @param length the length to set
	 */
	public void setLength(Long length) {
		this.length = length;
	}

	/**
	 * @return the lastModified
	 */
	public Date getLastModified() {
		return lastModified;
	}

	/**
	 * @param lastModified the lastModified to set
	 */
	public void setLastModified(Date lastModified) {
		this.lastModified = lastModified;
	}

	/**
	 * @return the data
	 */
	public byte[] getData() {
		return data;
	}

	/**
	 * @param data the data to set
	 */
	public void setData(byte[] data) {
		this.data = data;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();

		sb.append("{ ");
		sb.append("id: ").append(id);
		sb.append(", ");
		sb.append("parentId: ").append(parentId);
		sb.append(", ");
		sb.append("name: ").append(name);
		sb.append(", ");
		sb.append("folder: ").append(folder);
		sb.append(", ");
		sb.append("length: ").append(length);
		sb.append(", ");
		sb.append("lastModified: ").append(lastModified);
		sb.append(", ");
		sb.append("hidden: ").append(hidden);
		sb.append(", ");
		sb.append("readable: ").append(readable);
		sb.append(", ");
		sb.append("writeable: ").append(writeable);
		sb.append(", ");
		sb.append("data: ").append(data == null ? 0 : data.length);
		sb.append(" }");

		return sb.toString();
	}

	/**
     * @return  a hash code value for this object.
	 */
	@Override
	public int hashCode() {
		return ((id == null) ? 0 : id.hashCode());
	}

	/**
     * @return  <code>true</code> if this object is the same as the obj argument; 
     * 			<code>false</code> otherwise.
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		
		NdfsFile other = (NdfsFile)obj;
		if (id == null) {
			if (other.id != null) {
				return false;
			}
		}
		else if (!id.equals(other.id)) {
			return false;
		}

		return true;
	}

	/**
	 * Creates and returns a copy of this object.
	 * @return the copy object
	 */
	@Override
	public NdfsFile clone() {
		NdfsFile copy = new NdfsFile();
		
		copy.id = this.id;
		copy.parentId = this.parentId;
		copy.name = this.name;
		copy.folder = this.folder;
		copy.length = this.length;
		copy.lastModified = this.lastModified;
		copy.hidden = this.hidden;
		copy.readable = this.readable;
		copy.writeable = this.writeable;

		return copy;
	}

	/**
	 * @return true if file exists
	 */
	public boolean exists() {
		return id != null && folder != null;
	}
}

