/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs.ndfs;

import java.io.Serializable;
import java.util.Collection;

import nuts.core.orm.dao.DataAccessClient;
import nuts.core.orm.dao.DataAccessSession;
import nuts.exts.vfs.ndfs.dao.NdfsData;
import nuts.exts.vfs.ndfs.dao.NdfsDataDAO;
import nuts.exts.vfs.ndfs.dao.NdfsDataExample;
import nuts.exts.vfs.ndfs.dao.NdfsFile;
import nuts.exts.vfs.ndfs.dao.NdfsFileDAO;
import nuts.exts.vfs.ndfs.dao.NdfsFileExample;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

/**
 * A Ndfs File System
 */
@SuppressWarnings("serial")
public abstract class NdfsFileSystem extends AbstractFileSystem implements Serializable {
	private DataAccessClient dataAccessClient; 
	
	protected int blockSize = Integer.MAX_VALUE;
	
	/**
	 * @param rootName
	 * @param fileSystemOptions
	 */
	protected NdfsFileSystem(FileName rootName, 
			FileSystemOptions fileSystemOptions,
			DataAccessClient dataAccessClient) {
		super(rootName, null, fileSystemOptions);
		this.dataAccessClient = dataAccessClient;
	}

	public abstract NdfsFileDAO<NdfsFile, NdfsFileExample> createFileDAO(DataAccessSession das);
	
	public abstract NdfsDataDAO<NdfsData, NdfsDataExample> createDataDAO(DataAccessSession das);
	
	/**
	 * @return the dataAccessClient
	 */
	public DataAccessClient getDataAccessClient() {
		return dataAccessClient;
	}

	/**
	 * @param dataAccessClient the dataAccessClient to set
	 */
	public void setDataAccessClient(DataAccessClient dataAccessClient) {
		this.dataAccessClient = dataAccessClient;
	}

	/**
	 * @return the blockSize
	 */
	public int getBlockSize() {
		return blockSize;
	}

	/**
	 * @param blockSize the blockSize to set
	 */
	public void setBlockSize(int blockSize) {
		this.blockSize = blockSize;
	}

	protected FileObject createFile(AbstractFileName name) throws Exception {
		NdfsFileObject file = new NdfsFileObject(name, this);
		return file;
	}

	@SuppressWarnings("unchecked")
	protected void addCapabilities(Collection caps) {
		caps.addAll(NdfsFileProvider.capabilities);
	}
}
