/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

public class NutsTextFieldRenderer extends AbstractTemplateRenderer {
	public NutsTextFieldRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attr = new Attributes();

        attr.add("type", "text")
			.id(params)
			.name(params)
			.css(this, "n-textfield")
			.size(params)
			.maxlength(params)
			.disabled(params)
			.readonly(params)
			.tabindex(params)
			.formatValue(this)
			.title(params)
			.commons(params)
			.events(params)
			.dynamics(params);

		xtag("input", attr);

		writeMask();
    }
	
	private void writeMask() throws IOException {
		String mask = (String)params.get("mask");
		if (StringUtils.isNotEmpty(mask)) {
			String id = defs(jsstr((String)params.get("id")));
			write("<script type=\"text/javascript\">");
			write("$(function() { $(\"#" + id + "\").setMask(");
			if (mask.startsWith("{")) {
				write(mask);
			}
			else {
				write("\"");
				write(mask);
				write("\"");
			}
			write("); });");
			write("</script>");
		}
	}
}
