/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class NutsAnchorRenderer extends AbstractTemplateRenderer {

	public NutsAnchorRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attr = new Attributes();

		String icon = (String)params.get("icon");
		String body = (String)params.get("body");
		String sicon = (String)params.get("sicon");

		String css = "";
		if (StringUtils.isNotEmpty(icon) || StringUtils.isNotEmpty(sicon)) {
			css = StringUtils.isEmpty(body) ? " n-a-io" : " n-a-it";
		}
        
		attr.id(params)
        	.href(params)
        	.target(params)
        	.cssClass(params, "n-a" + css)
			.disabled(params)
        	.tabindex(params)
        	.title(params)
        	.cssStyle(params)
        	.commons(params)
        	.events(params)
        	.dynamics(params);
		stag("a", attr);

		if (StringUtils.isNotEmpty(icon)) {
			write(xicon(icon + " n-a-icon"));
		}

		if (StringUtils.isNotEmpty(body)) {
			body(body, false);
		}

		if (StringUtils.isNotEmpty(sicon)) {
			write(xicon(sicon + " n-a-sicon"));
		}
		etag("a");
    }
}

