/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nxhtml;

import java.util.Map;

import nuts.exts.struts2.views.java.EmptyRenderer;
import nuts.exts.struts2.views.java.TemplateRendererFactory;
import nuts.exts.struts2.views.java.simple.CheckboxListRenderer;
import nuts.exts.struts2.views.java.simple.CheckboxRenderer;
import nuts.exts.struts2.views.java.simple.FileRenderer;
import nuts.exts.struts2.views.java.simple.FormRenderer;
import nuts.exts.struts2.views.java.simple.LabelRenderer;
import nuts.exts.struts2.views.java.simple.NutsButtonRenderer;
import nuts.exts.struts2.views.java.simple.NutsCheckboxListRenderer;
import nuts.exts.struts2.views.java.simple.NutsCheckboxRenderer;
import nuts.exts.struts2.views.java.simple.NutsDatePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsDateTimePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsFileRenderer;
import nuts.exts.struts2.views.java.simple.NutsFormRenderer;
import nuts.exts.struts2.views.java.simple.NutsPasswordRenderer;
import nuts.exts.struts2.views.java.simple.NutsRadioMapRenderer;
import nuts.exts.struts2.views.java.simple.NutsResetRenderer;
import nuts.exts.struts2.views.java.simple.NutsSelectRenderer;
import nuts.exts.struts2.views.java.simple.NutsSubmitRenderer;
import nuts.exts.struts2.views.java.simple.NutsTextAreaRenderer;
import nuts.exts.struts2.views.java.simple.NutsTextFieldRenderer;
import nuts.exts.struts2.views.java.simple.NutsTimePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsTriggerFieldRenderer;
import nuts.exts.struts2.views.java.simple.NutsUploaderRenderer;
import nuts.exts.struts2.views.java.simple.NutsViewFieldRenderer;
import nuts.exts.struts2.views.java.simple.PasswordRenderer;
import nuts.exts.struts2.views.java.simple.RadioMapRenderer;
import nuts.exts.struts2.views.java.simple.ResetRenderer;
import nuts.exts.struts2.views.java.simple.SelectRenderer;
import nuts.exts.struts2.views.java.simple.SimpleTheme;
import nuts.exts.struts2.views.java.simple.SubmitRenderer;
import nuts.exts.struts2.views.java.simple.TextAreaRenderer;
import nuts.exts.struts2.views.java.simple.TextFieldRenderer;

public class NxhtmlTheme extends SimpleTheme {
	public NxhtmlTheme() {
		super();
		
		setName("nxhtml");

		Map<String, TemplateRendererFactory> rfs = this.getRendererFactories();

		rfs.put("checkbox", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, CheckboxRenderer.class));
		rfs.put("checkboxlist", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, CheckboxListRenderer.class));
		rfs.put("file", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, FileRenderer.class));
		rfs.put("form", new NxhtmlTemplateRendererFactory(
				FormHeaderWrapper.class, FormRenderer.class));
		rfs.put("form-close", new NxhtmlTemplateRendererFactory(
				FormFooterWrapper.class, FormRenderer.Close.class));
		rfs.put("label", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, LabelRenderer.class));
		rfs.put("password", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, PasswordRenderer.class));
		rfs.put("radiomap", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, RadioMapRenderer.class));
		rfs.put("reset", new NxhtmlTemplateRendererFactory(
				ButtonWrapper.class, ResetRenderer.class));
		rfs.put("select", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, SelectRenderer.class));
		rfs.put("submit", new NxhtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, SubmitRenderer.class));
		rfs.put("submit-close", new NxhtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, SubmitRenderer.Close.class));
		rfs.put("text", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, TextFieldRenderer.class));
		rfs.put("textarea", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, TextAreaRenderer.class));

		//nuts template
		rfs.put("n-b", new NxhtmlTemplateRendererFactory(
			ButtonHeaderWrapper.class, EmptyRenderer.class));
		rfs.put("n-b-close", new NxhtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsButtonRenderer.class));
		rfs.put("n-checkbox", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsCheckboxRenderer.class));
		rfs.put("n-checkboxlist", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsCheckboxListRenderer.class));
		rfs.put("n-datepicker", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsDatePickerRenderer.class));
		rfs.put("n-datetimepicker", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsDateTimePickerRenderer.class));
		rfs.put("n-file", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsFileRenderer.class));
		rfs.put("n-form", new NxhtmlTemplateRendererFactory(
				FormHeaderWrapper.class, NutsFormRenderer.class));
		rfs.put("n-form-close", new NxhtmlTemplateRendererFactory(
				FormFooterWrapper.class, NutsFormRenderer.Close.class));
		rfs.put("n-password", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsPasswordRenderer.class));
		rfs.put("n-radiomap", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsRadioMapRenderer.class));
		rfs.put("n-reset", new NxhtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, NutsResetRenderer.class));
		rfs.put("n-reset-close", new NxhtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsResetRenderer.Close.class));
		rfs.put("n-select", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsSelectRenderer.class));
		rfs.put("n-submit", new NxhtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, NutsSubmitRenderer.class));
		rfs.put("n-submit-close", new NxhtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsSubmitRenderer.Close.class));
		rfs.put("n-textfield", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTextFieldRenderer.class));
		rfs.put("n-textarea", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTextAreaRenderer.class));
		rfs.put("n-timepicker", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTimePickerRenderer.class));
		rfs.put("n-triggerfield", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTriggerFieldRenderer.class));
		rfs.put("n-uploader", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsUploaderRenderer.class));
		rfs.put("n-viewfield", new NxhtmlTemplateRendererFactory(
				FieldWrapper.class, NutsViewFieldRenderer.class));

		setRendererFactories(rfs);
	}
}
