/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nxhtml;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.exts.struts2.views.java.Attributes;

public abstract class FormWrapper extends NxhtmlTemplateRenderer {
	/**
	 * @param context context
	 */
	public FormWrapper(TemplateRenderingContext context) {
		super(context);
	}

	protected void renderHeader() throws Exception {
        Attributes a = new Attributes();
        a.add("class", join("n-xhtml", (String)params.get("cssClass")))
         .cssStyle(params);
        
		stag("table", a);
	}

	protected void renderFooter() throws Exception {
		etag("table");
	}
}
