/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.nthtml;

import java.util.Map;

import nuts.exts.struts2.views.java.EmptyRenderer;
import nuts.exts.struts2.views.java.TemplateRendererFactory;
import nuts.exts.struts2.views.java.simple.CheckboxListRenderer;
import nuts.exts.struts2.views.java.simple.CheckboxRenderer;
import nuts.exts.struts2.views.java.simple.FileRenderer;
import nuts.exts.struts2.views.java.simple.FormRenderer;
import nuts.exts.struts2.views.java.simple.LabelRenderer;
import nuts.exts.struts2.views.java.simple.NutsButtonRenderer;
import nuts.exts.struts2.views.java.simple.NutsCheckboxListRenderer;
import nuts.exts.struts2.views.java.simple.NutsCheckboxRenderer;
import nuts.exts.struts2.views.java.simple.NutsDatePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsDateTimePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsFileRenderer;
import nuts.exts.struts2.views.java.simple.NutsFormRenderer;
import nuts.exts.struts2.views.java.simple.NutsPasswordRenderer;
import nuts.exts.struts2.views.java.simple.NutsRadioMapRenderer;
import nuts.exts.struts2.views.java.simple.NutsResetRenderer;
import nuts.exts.struts2.views.java.simple.NutsSelectRenderer;
import nuts.exts.struts2.views.java.simple.NutsSubmitRenderer;
import nuts.exts.struts2.views.java.simple.NutsTextAreaRenderer;
import nuts.exts.struts2.views.java.simple.NutsTextFieldRenderer;
import nuts.exts.struts2.views.java.simple.NutsTimePickerRenderer;
import nuts.exts.struts2.views.java.simple.NutsTriggerFieldRenderer;
import nuts.exts.struts2.views.java.simple.NutsUploaderRenderer;
import nuts.exts.struts2.views.java.simple.NutsViewFieldRenderer;
import nuts.exts.struts2.views.java.simple.PasswordRenderer;
import nuts.exts.struts2.views.java.simple.RadioMapRenderer;
import nuts.exts.struts2.views.java.simple.ResetRenderer;
import nuts.exts.struts2.views.java.simple.SelectRenderer;
import nuts.exts.struts2.views.java.simple.SimpleTheme;
import nuts.exts.struts2.views.java.simple.SubmitRenderer;
import nuts.exts.struts2.views.java.simple.TextAreaRenderer;
import nuts.exts.struts2.views.java.simple.TextFieldRenderer;

public class NthtmlTheme extends SimpleTheme {
	public NthtmlTheme() {
		super();
		
		setName("nthtml");

		Map<String, TemplateRendererFactory> rfs = this.getRendererFactories();

		rfs.put("checkbox", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, CheckboxRenderer.class));
		rfs.put("checkboxlist", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, CheckboxListRenderer.class));
		rfs.put("file", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, FileRenderer.class));
		rfs.put("form", new NthtmlTemplateRendererFactory(
				FormHeaderWrapper.class, FormRenderer.class));
		rfs.put("form-close", new NthtmlTemplateRendererFactory(
				FormFooterWrapper.class, FormRenderer.Close.class));
		rfs.put("label", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, LabelRenderer.class));
		rfs.put("password", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, PasswordRenderer.class));
		rfs.put("radiomap", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, RadioMapRenderer.class));
		rfs.put("reset", new NthtmlTemplateRendererFactory(
				ButtonWrapper.class, ResetRenderer.class));
		rfs.put("select", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, SelectRenderer.class));
		rfs.put("submit", new NthtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, SubmitRenderer.class));
		rfs.put("submit-close", new NthtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, SubmitRenderer.Close.class));
		rfs.put("text", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, TextFieldRenderer.class));
		rfs.put("textarea", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, TextAreaRenderer.class));

		//nuts template
		rfs.put("n-b", new NthtmlTemplateRendererFactory(
			ButtonHeaderWrapper.class, EmptyRenderer.class));
		rfs.put("n-b-close", new NthtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsButtonRenderer.class));
		rfs.put("n-checkbox", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsCheckboxRenderer.class));
		rfs.put("n-checkboxlist", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsCheckboxListRenderer.class));
		rfs.put("n-datepicker", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsDatePickerRenderer.class));
		rfs.put("n-datetimepicker", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsDateTimePickerRenderer.class));
		rfs.put("n-file", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsFileRenderer.class));
		rfs.put("n-form", new NthtmlTemplateRendererFactory(
				FormHeaderWrapper.class, NutsFormRenderer.class));
		rfs.put("n-form-close", new NthtmlTemplateRendererFactory(
				FormFooterWrapper.class, NutsFormRenderer.Close.class));
		rfs.put("n-password", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsPasswordRenderer.class));
		rfs.put("n-radiomap", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsRadioMapRenderer.class));
		rfs.put("n-reset", new NthtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, NutsResetRenderer.class));
		rfs.put("n-reset-close", new NthtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsResetRenderer.Close.class));
		rfs.put("n-select", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsSelectRenderer.class));
		rfs.put("n-submit", new NthtmlTemplateRendererFactory(
				ButtonHeaderWrapper.class, NutsSubmitRenderer.class));
		rfs.put("n-submit-close", new NthtmlTemplateRendererFactory(
				ButtonFooterWrapper.class, NutsSubmitRenderer.Close.class));
		rfs.put("n-textfield", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTextFieldRenderer.class));
		rfs.put("n-textarea", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTextAreaRenderer.class));
		rfs.put("n-timepicker", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTimePickerRenderer.class));
		rfs.put("n-triggerfield", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsTriggerFieldRenderer.class));
		rfs.put("n-uploader", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsUploaderRenderer.class));
		rfs.put("n-viewfield", new NthtmlTemplateRendererFactory(
				FieldWrapper.class, NutsViewFieldRenderer.class));

		setRendererFactories(rfs);
	}
}
