/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;

/**
 * ListUIBean is the standard superclass of all Nuts Struts list handling components.
 *
 * <p/>
 *
 * <!-- START SNIPPET: javadoc -->
 *
 * Note that the listkey and listvalue attribute will default to "key" and "value"
 * respectively only when the list attribute is evaluated to a Map or its decendant.
 * Everything else will result in listkey and listvalue to be null and not used.
 *
 * <!-- END SNIPPET: javadoc -->
 *
 */
public abstract class UIBean extends org.apache.struts2.components.UIBean {
    private static final Logger log = LoggerFactory.getLogger(UIBean.class);

    public UIBean(ValueStack stack, HttpServletRequest request,
			HttpServletResponse response) {
		super(stack, request, response);
	}

	protected Set<String> getStandardAttributes() {
        Class clz = getClass();
        Set<String> standardAttributes = standardAttributesMap.get(clz);
        if (standardAttributes == null) {
            standardAttributes = new HashSet<String>();
            standardAttributesMap.put(clz, standardAttributes);
            while (clz != null) {
        		BeanInfo beanInfo;
        		try {
        			beanInfo = Introspector.getBeanInfo(clz);
        		}
        		catch (IntrospectionException e) {
        			log.error("Failed to getBeanInfo(" + clz + ")", e);
        			break;
        		}

        		for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
        			Method sm = pd.getWriteMethod();
        			if (sm != null) {
        				Class<?>[] pts = sm.getParameterTypes();
        				if (Modifier.isPublic(sm.getModifiers())
        					&& ((pts.length == 1 && pts[0].equals(String.class))
        						|| (clz.equals(ListUIBean.class) && pd.getName().equals("list")))) {
        					standardAttributes.add(pd.getName());
        				}
        			}
                }
                if (clz.equals(UIBean.class)) {
                    break;
                } 
                else {
                    clz = clz.getSuperclass();
                }
            }
        }
		return standardAttributes;
	}
}
