/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.components;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Form;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;

import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;

/**
 * <!-- START SNIPPET: javadoc --> Renders an HTML file input element. <!-- END SNIPPET: javadoc -->
 * <p/>
 * <b>Examples</b>
 * 
 * <pre>
 * &lt;!-- START SNIPPET: example --&gt;
 * &lt;s:file name=&quot;anUploadFile&quot; accept=&quot;text/*&quot; /&gt;
 * &lt;s:file name=&quot;anohterUploadFIle&quot; accept=&quot;text/html,text/plain&quot; /&gt;
 * &lt;!-- END SNIPPET: example --&gt;
 * </pre>
 */
@StrutsTag(
		name = "file", 
		tldTagClass = "nuts.exts.struts2.views.jsp.ui.FileTag", 
		description = "Render a file input field", 
		allowDynamicAttributes = true)
public class File extends UIBean {
	private final static Logger LOG = LoggerFactory.getLogger(File.class);

	private final static String TEMPLATE = "n-file";

	protected String accept;
	protected String size;

	/**
	 * Constructor
	 * 
	 * @param stack value stack
	 * @param request request
	 * @param response response
	 */
	public File(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
		super(stack, request, response);
	}

	protected String getDefaultTemplate() {
		return TEMPLATE;
	}

	/**
	 * evaluate parameters
	 */
	public void evaluateParams() {
		super.evaluateParams();

		Form form = (Form) findAncestor(Form.class);
		if (form != null) {
			String encType = (String) form.getParameters().get("enctype");
			if (!"multipart/form-data".equals(encType)) {
				// uh oh, this isn't good! Let's warn the developer
				LOG
					.warn("A file upload UI tag (r.file) being used without a form set to enctype 'multipart/form-data'. This is probably an error!");
			}

			String method = (String) form.getParameters().get("method");
			if (!"post".equalsIgnoreCase(method)) {
				// uh oh, this isn't good! Let's warn the developer
				LOG
					.warn("A file upload UI tag (r.file) being used without a form set to method 'POST'. This is probably an error!");
			}
		}

		if (accept != null) {
			addParameter("accept", findString(accept));
		}

		if (size != null) {
			addParameter("size", findString(size));
		}
	}

	/**
	 * @param accept the accept to set
	 */
	@StrutsTagAttribute(description = "HTML accept attribute to indicate accepted file mimetypes")
	public void setAccept(String accept) {
		this.accept = accept;
	}

	/**
	 * @param size the size to set
	 */
	@StrutsTagAttribute(description = "HTML size attribute", required = false, type = "Integer")
	public void setSize(String size) {
		this.size = size;
	}
}
