/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import nuts.core.util.Profiler;

import java.text.SimpleDateFormat;
import java.util.Calendar;


public class CommonSyncWorkAction extends CommonWorkAction {
	protected String time;
	protected boolean stop = true;
	protected boolean running = false;
	protected int count;
	protected String status;

	/**
	 * @return the time
	 */
	public String getTime() {
		return getInstance().time;
	}

	/**
	 * @return the count
	 */
	public int getCount() {
		return getInstance().count;
	}

	/**
	 * @return the Status
	 */
	public String getStatus() {
		return getInstance().status;
	}

	/**
	 * @return the stop
	 */
	public boolean isStop() {
		return getInstance().stop;
	}

	/**
	 * @return the running
	 */
	public boolean isRunning() {
		return getInstance().running;
	}

	/**
	 * get singleton instance
	 * @return instance
	 */
	protected CommonSyncWorkAction getInstance() {
		CommonSyncWorkAction a = (CommonSyncWorkAction)getApplication().get(getClass().getName());
		return a == null ? this : a;
	}

	/**
	 * set singleton instance
	 * @param instance instance
	 */
	protected void setInstance(CommonSyncWorkAction instance) {
		if (instance == null) {
			getApplication().remove(getClass().getName());
		}
		else {
			getApplication().put(getClass().getName(), instance);
		}
	}
	
	public String stop() {
		getInstance().doStop();
		return SUCCESS;
	}
	
	protected void doStop() {
		stop = true;
		while (running) {
			try {
				Thread.sleep(100);
			} 
			catch (InterruptedException e) {
				break;
			}
		}
		time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(Calendar.getInstance().getTime());
	}
	
	public String status() {
		time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(Calendar.getInstance().getTime());
		return SUCCESS;
	}

	public String execute() {
		try {
			init();
			if (isRunning()) {
				doProgress();
			}
			else {
				try {
					Profiler profiler = new Profiler();
					count = 0;
					stop = false;
					running = true;
					setInstance(this);
					doExecute();
					printSuccess(count + " items processed, took " + profiler.timespan() + ".");
				}
				finally {
					running = false;
					setInstance(null);
				}
			}
		}
		catch (Throwable e) {
			log.warn("execute", e);
			try {
				printError(e.getMessage());
			}
			catch (Exception ex) {
			}
		}
		finally {
			release();
		}
		return NONE;
	}

	protected void release() {
		
	}
	
	protected void doProgress() throws Exception {
		CommonSyncWorkAction action = getInstance();
		
		int cnt = 0;
		while (action.running) {
			while (action.running && cnt == action.count) {
				Thread.sleep(500);
			}
			cnt = action.count;
			printStatus(action.count, action.status);
		}
		printSuccess(String.valueOf(action.count));
	}

	protected void doExecute() throws Throwable {
	}
	
	@Override
	protected void printStatus(int count, String msg) {
		status = msg;
		super.printStatus(count, msg);
	}

}
