/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2;

/**
 * This class provides a central location for framework configuration keys
 * used to retrieve and store Struts configuration settings.
 */
public class NutsStrutsConstants {

	/** */
	public static final String NUTS_JSON_SHORT_NAME = "nuts.json.shortname";

	/** */
	public static final String NUTS_XML_SHORT_NAME = "nuts.xml.shortname";

	/**  */
	public static final String NUTS_WELCOME_TO_SLASH = "nuts.welcome.to.slash";
	
	/**  */
	public static final String NUTS_WELCOME_IGNORE_DOT = "nuts.welcome.ignoredot";
	
	/** the default package of struts configuration */
	public static final String NUTS_PACKAGE_DEFAULT = "nuts.package.default";

	/**
	 * NUTS_ACTION_SUPPORT = "nuts.action.support";
	 */
	public static final String NUTS_ACTION_SUPPORT = "nuts.action.support";

	/** The welcome action */
	public static final String NUTS_ACTION_WELCOME = "nuts.action.welcome";
	
	/** The action utils */
	public static final String NUTS_ACTION_UTILS = "nuts.action.utils";

	/** The action consts */
	public static final String NUTS_ACTION_CONSTS = "nuts.action.consts";

	/** The fonts path */
	public static final String NUTS_FONTS_PATH = "nuts.fonts.path";

	/** The valid locale */
	public static final String NUTS_LOCALE_VALID = "nuts.locale.valid";

	/** The default loadmask option of form */
	public static final String NUTS_FORM_LOADMASK = "nuts.form.loadmask";

	/** The default includeParams method to generate Struts URLs */
	public static final String NUTS_URL_INCLUDEPARAMS = "nuts.url.includeParams";

	/** The default encode method to generate Struts URLs */
	public static final String NUTS_URL_ENCODE = "nuts.url.encode";
	
	/** The default escapeAmp method to generate Struts URLs */
	public static final String NUTS_URL_ESCAPEAMP = "nuts.url.escapeAmp";

	/** The checkbox intercept */
	public static final String NUTS_CHECKBOX_INTERCEPT = "nuts.checkbox.intercept";

	/** The multiselect intercept */
	public static final String NUTS_MULTISELECT_INTERCEPT = "nuts.multiselect.intercept";

	/** The defaults of datepicker */
	public static final String NUTS_DATEPICKER_DEFAULTS = "nuts.datepicker.defaults";
	
	/** The defaults of timepicker */
	public static final String NUTS_TIMEPICKER_DEFAULTS = "nuts.timepicker.defaults";
	
	/** The defaults of datetimepicker */
	public static final String NUTS_DATETIMEPICKER_DEFAULTS = "nuts.datetimepicker.defaults";
	
    /** The maximize size of a multipart request (file upload) */
    public static final String NUTS_MULTIPART_MAXSIZE = "nuts.multipart.maxSize";

    /** The directory to use for storing uploaded files */
    public static final String NUTS_MULTIPART_SAVEDIR = "nuts.multipart.saveDir";
}
