/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.mybatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

/**
 * AbstractBooleanTypeHandler
 */
public abstract class AbstractBooleanTypeHandler implements TypeHandler {
	protected abstract String getTrueText();
	protected abstract String getFalseText();

	/**
	 */
	public void setParameter(PreparedStatement ps, int i, Object parameter, JdbcType jdbcType) throws SQLException {
		ps.setString(i, parameter == null ? null : (((Boolean)parameter) ? getTrueText(): getFalseText()));
	}

	protected Boolean convertFromString(String s) throws SQLException {
		if (s == null) {
			return null;
		}
		else if (getTrueText().equalsIgnoreCase(s)) {
			return Boolean.TRUE;
		}
		else if (getFalseText().equalsIgnoreCase(s)) {
			return Boolean.FALSE;
		}
		else {
			throw new SQLException(
				"Unexpected value " + s + " found where " + getTrueText() + " or " + getFalseText() + " was expected.");
		}
	}

	/**
	 */
	public Object getResult(ResultSet rs, String columnName) throws SQLException {
		String s = rs.getString(columnName);
		if (rs.wasNull()) {
			return null;
		}
		return convertFromString(s);
	}

	/**
	 */
	public Object getResult(CallableStatement cs, int columnIndex) throws SQLException {
		String s = cs.getString(columnIndex);
		if (cs.wasNull()) {
			return null;
		}
		return convertFromString(s);
	}
}
