/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.jcache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheStatistics;

/**
 */
public class JCacheProxy implements Cache {
	private Map map;
	
	public JCacheProxy(Map map) {
		this.map = map;
	}

	private Object toCompareKey(Object key) {
		return key instanceof String ? ((String)key).toLowerCase() : key; 
	}

	public void clear() {
		map.clear();
	}

	public boolean containsKey(Object key) {
		return map.containsKey(toCompareKey(key));
	}

	public boolean containsValue(Object value) {
		return map.containsValue(value);
	}

	@SuppressWarnings("unchecked")
	public Set<java.util.Map.Entry> entrySet() {
		return map.entrySet();
	}

	public Object get(Object key) {
		return map.get(toCompareKey(key));
	}

	public boolean isEmpty() {
		return map.isEmpty();
	}

	public Set keySet() {
		return map.keySet();
	}

	@SuppressWarnings("unchecked")
	public Object put(Object key, Object value) {
		return map.put(key, value);
	}

	@SuppressWarnings("unchecked")
	public void putAll(Map m) {
		map.putAll(m);
	}

	public Object remove(Object key) {
		return map.remove(key);
	}

	public int size() {
		return map.size();
	}

	public Collection values() {
		return map.values();
	}

	public boolean equals(Object o) {
        return map.equals(o);
    }
	
	public int hashCode() {
        return map.hashCode();
    }

	public String toString() {
		return map.toString();
    }

	public Map getAll(Collection keys) throws CacheException {
		throw new UnsupportedOperationException();
	}

	public void load(Object key) throws CacheException {
		throw new UnsupportedOperationException();
	}

	public void loadAll(Collection keys) throws CacheException {
		throw new UnsupportedOperationException();
	}

	public Object peek(Object key) {
		throw new UnsupportedOperationException();
	}

	public CacheEntry getCacheEntry(Object key) {
		throw new UnsupportedOperationException();
	}

	public CacheStatistics getCacheStatistics() {
		throw new UnsupportedOperationException();
	}

	public void evict() {
	}

	public void addListener(CacheListener listener) {
	}

	public void removeListener(CacheListener listener) {
	}
}
