/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.xwork2.validator.validators;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import nuts.exts.struts2.test.ActionTestCase;
import nuts.exts.struts2.test.TestAction;
import nuts.exts.struts2.test.TestBean;

import com.opensymphony.xwork2.ActionProxy;

/**
 * @see DateRangeFieldValidator
 */
public class DateRangeFieldValidatorTest extends ActionTestCase {
	private final static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");

	protected void doSuccessTest(String action, String sDate) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setDateField(dateFormat.parse(sDate));
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.SUCCESS, result);

		String rc = getResponseContentAsString();

		JSONObject rjo = JSONObject.fromObject(rc);
		assertTrue(rjo.getBoolean("success"));
	}

	protected void doErrorTest(String action, String sDate) throws Exception {
		TestBean tbd = new TestBean();

		Map<String, String> rps = new HashMap<String, String>();

		tbd.setDateField(dateFormat.parse(sDate));
		tbd.setDataToMap(rps, "bean.");

		ActionProxy proxy = createActionProxy("/test", action, null, rps);

		assertTrue(proxy.getAction() instanceof TestAction);

		// Run the Struts Interceptor stack and the Action
		String result = proxy.execute();

		// Check the results
		assertEquals(TestAction.INPUT, result);

		String rc = getResponseContentAsString();

		JSONObject rjo = JSONObject.fromObject(rc);
		assertFalse(rjo.getBoolean("success"));

		JSONObject fes = rjo.getJSONObject("fieldErrors");
		assertNotNull(fes);
		assertTrue(fes.containsKey("bean.dateField"));
	}

	/**
	 *	[2007/1/1 - 2009/1/1]<br>
	 * field valie: "2008/12/1"<br>
	 * expect success
	 * @throws Exception if an error occurs
	 */
	public void test001() throws Exception {
		doSuccessTest("datevalidate", "2008/12/1");
	}

	/**
	 *	[2007/1/1 - 2009/1/1]<br>
	 * field valie: "2010/1/1"<br>
	 * expect error
	 * @throws Exception if an error occurs
	 */
	public void test002() throws Exception {
		doErrorTest("datevalidate", "2010/1/1");
	}

}
