/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views;

import java.text.SimpleDateFormat;

import nuts.exts.struts2.test.ActionTestCase;
import nuts.exts.struts2.test.TestAction;

/**
 * Test Date Tag
 * @see nuts.exts.struts2.components.CDate
 */
public class DateTagTest extends ActionTestCase {

	private void doTest(String format) throws Exception {
		doRequest("/test/datetagtest_" + format, 
			'/' + TestAction.class.getName().replace('.', '/') + "Data.properties");

		TestAction ta = (TestAction)getAction();

        SimpleDateFormat dateFormat = new SimpleDateFormat(ta.getText("date-format-" + format));

		String rc = getResponseContentAsString();

		assertEquals(dateFormat.format(ta.getBean().getDateField()), rc);
	}

	/**
	 * test 'date' format
	 * @throws Exception if an error occurs
	 */
	public void testDate() throws Exception {
		doTest("date");
	}

	/**
	 * test 'time' format
	 * @throws Exception if an error occurs
	 */
	public void testTime() throws Exception {
		doTest("time");
	}

	/**
	 * test 'datetime' format
	 * @throws Exception if an error occurs
	 */
	public void testDateTime() throws Exception {
		doTest("datetime");
	}

	/**
	 * test 'value' set
	 * @throws Exception if an error occurs
	 */
	public void testDateValue() throws Exception {
		doRequest("/test/datetagtest_value", 
			'/' + TestAction.class.getName().replace('.', '/') + "Data.properties");

		TestAction ta = (TestAction)getAction();

        SimpleDateFormat dateFormat = new SimpleDateFormat(ta.getText("date-format-datetime"));

		String rc = getResponseContentAsString();

		assertEquals(dateFormat.format(ta.getBean().getDateField()), rc);
	}
}
