<#--
/*
 * This file is part of Nuts.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<html>
<head>
	<title><@n.text name="title-page"/></title>
</head>

<body>

<div class="n-sect" id="a_commonwork">
	<div class="n-sect-head">
		<h3 class="n-sect-title"><@n.text name="title-page"/></h3>
	</div>
	<div class="n-sect-body">
		<#include "/nuts/exts/struts2/views/action-prompt.ftl"/>
		
		<@n.form id="commonwork" class="n-eform" theme="nxhtml" onsubmit="return false;">
			<@n.submit icon="icon-execute" onclick="return doExecute();"><@n.text name="button-execute"/></@n.submit>
		</@n.form>

		<div class="hr"></div>

		<div>
			<@n.submit icon="icon-stop" onclick="doStop()"><@n.text name="button-stop"/></@n.submit>
			<@n.submit icon="icon-status" onclick="doStatus()"><@n.text name="button-status"/></@n.submit>
		</div>
		
		<br/>
		<div id="commonwork_t"></div>
		
		<br/>
		<div id="commonwork_i">
			<div class="hr"></div>
		</div>
		<br/>
		<br/>

		<script type="text/javascript">
			var $hr = $('#commonwork_i .hr');
			var pms = [];

			function doStop() {
				var data = {
					__decorator: 'none'
				};

				$.ajaf({
					url: "<@n.url action='${actionPrefix}_stop'/>",
					data: data,
					success: function(data) {
						$('#commonwork_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
					},
					error: function(xhr, status, e) {
						$('#commonwork_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			var timer;
			function doStatus() {
				if (timer) {
					clearInterval(timer);
					timer = null;
					$('#commonwork_t').empty();
				}
				else {
					timer = setInterval(function() {
						var data = {
							__decorator: 'none'
						};
		
						$.ajaf({
							url: "<@n.url action='${actionPrefix}_status'/>",
							data: data,
							success: function(data) {
								$('#commonwork_t').html('<pre>' + data.formatXml().escapeHtml() + '</pre>');
							},
							error: function(xhr, status, e) {
								$('#commonwork_t').html('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
							}
						});
					}, 1000);
				}
			}
			
			function doExecute() {
				doWork("<@n.url action='${actionPrefix}_execute'/>");
				return false;
			}

			function doWork(url) {
				$('#commonwork').loadmask();
				$('#commonwork_t').empty();
				
				pms = [];

				var data = {
					__decorator: 'none',
					error: 'parent.work_error("{0}");',
					process: 'parent.work_process({0}, "{1}");',
					success: 'parent.work_success("{0}");'
				};
				
				$.ajaf({
					url: url,
					data: data,
					success: function(d) {
						$('#commonwork').unloadmask();
					},
					error: function(xhr, status, e) {
						$('#commonwork').unloadmask();
						$hr.after('<div class="error">' + String.escapeHtml(xhr.responseText) + '</div>');
					}
				});
			}
			
			function work_error(msg) {
				$hr.after('<pre class="error">' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</pre>');
			}
			
			function work_success(msg) {
				msg = '{0} items processed.'.replace('{0}', msg);
				$hr.after('<div>' + String.escapeHtml(msg).replace(/\r\n/g, '<br/>') + '</div>');
			}
			
			function work_process(progress, msg) {
				var $m = $('<div>' + String.escapeHtml(progress + '. ' + msg).replace(/\r\n/g, '<br/>') + '</div>');

				$hr.after($m);
				pms.push($m);

				while (pms.length > 20) {
					pms.shift().remove();
				}
			}
		</script>
	</div>
</div>

</body>
</html>
