/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.vfs.ndfs;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;

/**
 * A file system provider, which uses direct file access.
 * 
 */
public class NdfsFileProvider extends AbstractOriginatingFileProvider {
	public final static Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(new Capability[] {
			Capability.CREATE, Capability.DELETE, Capability.RENAME,
			Capability.GET_TYPE, Capability.GET_LAST_MODIFIED,
			Capability.SET_LAST_MODIFIED_FILE,
			Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN,
			Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT,
			Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ,
			Capability.RANDOM_ACCESS_WRITE }));

    /**
     * Get the filesystem capabilities.<br>
     * These are the same as on the filesystem, but available before the first filesystem was
     * instanciated.
     */
	public Collection<Capability> getCapabilities() {
		return capabilities;
	}

	/**
	 * Creates the File System.
	 */
	protected FileSystem doCreateFileSystem(final FileName name,
			final FileSystemOptions options)
			throws FileSystemException {
		//TODO
		return null;
	}
}
