/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.jsp.ui;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.exts.struts2.components.Link;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ui.AbstractUITag;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * @see Link
 */
@SuppressWarnings("serial")
public class LinkTag extends AbstractUITag {

	// attributes
	protected String statics;
	protected String version;
	protected String debug;
	protected String cdn;
	protected String script;
	protected String style;
	protected String locale;
	protected String jquery;
	protected String jqueryUi;
	protected String jqueryPlugins;
	protected String nuts;
	protected String extjs;
	protected String extux;
	protected String nexts;
	protected String uiTheme;
	protected String exTheme;
	protected String showLoading;
	protected String closeLoading;

	/**
	 * @param statics the statics to set
	 */
	public void setStatics(String statics) {
		this.statics = statics;
	}

	/**
	 * @param version the version to set
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 * @param debug the debug to set
	 */
	public void setDebug(String debug) {
		this.debug = debug;
	}

	/**
	 * @param cdn the cdn to set
	 */
	public void setCdn(String cdn) {
		this.cdn = cdn;
	}

	/**
	 * @param script the script to set
	 */
	public void setScript(String script) {
		this.script = script;
	}

	/**
	 * @param style the style to set
	 */
	public void setStyle(String style) {
		this.style = style;
	}

	/**
	 * @param locale the locale to set
	 */
	public void setLocale(String locale) {
		this.locale = locale;
	}

	/**
	 * @param jquery the jquery to set
	 */
	public void setJquery(String jquery) {
		this.jquery = jquery;
	}

	/**
	 * @param jqueryUi the jqueryUi to set
	 */
	public void setJqueryUi(String jqueryUi) {
		this.jqueryUi = jqueryUi;
	}

	/**
	 * @param jqueryPlugins the jqueryPlugins to set
	 */
	public void setJqueryPlugins(String jqueryPlugins) {
		this.jqueryPlugins = jqueryPlugins;
	}

	/**
	 * @param nuts the nuts to set
	 */
	public void setNuts(String nuts) {
		this.nuts = nuts;
	}

	/**
	 * @param extjs the extjs to set
	 */
	public void setExtjs(String extjs) {
		this.extjs = extjs;
	}

	/**
	 * @param extux the extux to set
	 */
	public void setExtux(String extux) {
		this.extux = extux;
	}

	/**
	 * @param nexts the nexts to set
	 */
	public void setNexts(String nexts) {
		this.nexts = nexts;
	}

	/**
	 * @param uiTheme the uiTheme to set
	 */
	public void setUiTheme(String uiTheme) {
		this.uiTheme = uiTheme;
	}

	/**
	 * @param exTheme the exTheme to set
	 */
	public void setExTheme(String exTheme) {
		this.exTheme = exTheme;
	}

	/**
	 * @param showLoading the showLoading to set
	 */
	public void setShowLoading(String showLoading) {
		this.showLoading = showLoading;
	}

	/**
	 * @param closeLoading the closeLoading to set
	 */
	public void setCloseLoading(String closeLoading) {
		this.closeLoading = closeLoading;
	}

	/**
	 * @see org.apache.struts2.views.jsp.ComponentTagSupport#getBean(com.opensymphony.xwork2.util.ValueStack,
	 *      javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public Component getBean(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		return new Link(stack, req, res);
	}

	/**
	 * @see org.apache.struts2.views.jsp.ui.AbstractUITag#populateParams()
	 */
	protected void populateParams() {
		super.populateParams();

		Link link = ((Link)component);
		link.setStatics(statics);
		link.setVersion(version);
		link.setDebug(debug);
		link.setCdn(cdn);
		link.setScript(script);
		link.setStyle(style);
		link.setLocale(locale);
		link.setJquery(jquery);
		link.setJqueryUi(jqueryUi);
		link.setJqueryPlugins(jqueryPlugins);
		link.setNuts(nuts);
		link.setExtjs(extjs);
		link.setExtux(extux);
		link.setNexts(nexts);
		link.setUiTheme(uiTheme);
		link.setExTheme(exTheme);
		link.setShowLoading(showLoading);
		link.setCloseLoading(closeLoading);
	}

}
