/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import org.apache.struts2.components.template.TemplateRenderingContext;

public class SubmitRenderer extends AbstractTemplateRenderer {

	public SubmitRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attrs = new Attributes();

        String type = defs((String) params.get("type"), "input");

        if ("button".equals(type)) {
            attrs.add("type", "submit")
            	.id(params)
            	.name(params)
            	.cssClass(params)
            	.nameValue(params)
            	.disabled(params)
            	.tabindex(params)
            	.cssStyle(params)
            	.commons(params)
            	.events(params)
            	.dynamics(params);
            stag("button", attrs);
        }
        else if ("image".equals(type)) {
            attrs.add("type", "image")
            	.src(params)
            	.addIfExists("alt", params.get("label"));
            xtag("input", attrs);
        }
        else {
            attrs.add("type", "submit")
            	.id(params)
            	.name(params)
            	.cssClass(params)
            	.disabled(params)
            	.tabindex(params)
            	.nameValue(params)
            	.cssStyle(params)
            	.title(params)
            	.commons(params)
            	.events(params)
            	.dynamics(params);

            xtag("input", attrs);
        }
    }

    public static class Close extends AbstractTemplateRenderer {
        public Close(TemplateRenderingContext context) {
			super(context);
		}

		public void render() throws IOException {
            String body = (String) params.get("body");

            String type = defs((String) params.get("type"), "input");
            if ("button".equals(type)) {
                //button body
                if (StringUtils.isNotEmpty(body)) {
                    body(body, false);
                }
                else if (params.containsKey("label")) {
                    String label = (String) params.get("label");
                    if (StringUtils.isNotEmpty(label)) {
                        body(label, false);
                    }
                }
                etag("button");
            }
            else {
                if (StringUtils.isNotEmpty(body)) {
                    body(body, false);
                }
            }
        }
    }
}
