/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;
import java.util.Iterator;

import nuts.core.lang.ObjectUtils;
import nuts.exts.struts2.components.Property;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.util.ContainUtil;
import org.apache.struts2.util.MakeIterator;

public class NutsViewFieldRenderer extends AbstractTemplateRenderer {
	public NutsViewFieldRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
		Attributes a = null;

		Object value = params.get("nameValue");
		if (MakeIterator.isIterable(value)) {
			Iterator itt = MakeIterator.convert(value);
			while (itt.hasNext()) {
				Object item = itt.next();
				a = new Attributes();
				a.add("type", "hidden")
				 .id(params)
				 .name(params)
				 .disabled(params)
				 .add("value", String.valueOf(item == null ? "" : item), true);
				xtag("input", a);
			}
		}
		else {
			a = new Attributes();
			a.add("type", "hidden")
			 .id(params)
			 .name(params)
			 .disabled(params)
			 .nameValue(this);
			xtag("input", a);
		}
		
		a = new Attributes();
		a.title(params)
		 .css(this, "n-viewfield")
		 .commons(params)
		 .dynamics(params);
		stag("span", a);

		StringBuilder body = new StringBuilder();
		if (ObjectUtils.isNotEmpty(value)) {
			String iconClass = (String)params.get("iconClass");
			if (iconClass != null) {
				body.append(icon(iconClass + " n-vf-icon"));
			}

			if (params.get("list") != null) {
				Object listObj = params.get("list");

				String listKey = (String)params.get("listKey");
				String listValue = (String)params.get("listValue");

				Iterator itt = MakeIterator.convert(listObj);
				while (itt.hasNext()) {
					Object item = itt.next();
					stack.push(item);

					// key
					Object itemKey = findValue(listKey != null ? listKey : "top");
					// value
					Object itemValue = findValue(listValue != null ? listValue : "top");

					boolean selected = ContainUtil.contains(value, itemKey);

					stack.pop();

					if (selected) {
						body.append(itemValue == null ? null : itemValue.toString());
						body.append(' ');
					}
				}
			}
			else if (params.get("expression") != null) {
				String expr = (String)params.get("expression");

				String format = (String)params.get("format");
				Property p = new Property(stack);
				try {
					p.setName(expr);
					p.setFormat(format);
					String escape = (String)params.get("escape");
					if (escape != null) {
						p.setEscape(escape);
					}
					String v = p.formatValue();
					body.append(v);
				}
				finally {
					p.getComponentStack().pop();
				}
			}
			else {
				body.append(formatValue(Property.ESCAPE_PHTML));
			}
		}
		
		if (body.length() > 0) {
			write(body.toString());
		}
		else {
			write("&nbsp;");
		}
		etag("span");
	}
}
