/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;
import java.util.Iterator;

import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.util.ContainUtil;
import org.apache.struts2.util.MakeIterator;

public class NutsRadioMapRenderer extends AbstractTemplateRenderer {
	public NutsRadioMapRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
		String id = (String)params.get("id");
		String name = (String)params.get("name");
        Object value = params.get("nameValue");

        write("<div id=\"" + html(id) + "\" class=\"n-radiomap\">");
        
		// header
		String headerKey = (String)params.get("headerKey");
		String headerValue = (String)params.get("headerValue");
		if (headerKey != null && headerValue != null) {
			boolean checked = ContainUtil.contains(value,
					params.get("headerKey"));
			writeItem(name, id, 0, headerKey, headerValue, checked);
		}

		Object listObj = params.get("list");
		if (listObj != null) {
			String listKey = (String)params.get("listKey");
			String listValue = (String)params.get("listValue");

			int itemCount = 0;
			Iterator itt = MakeIterator.convert(listObj);
			while (itt.hasNext()) {
				itemCount++;
				
				Object item = itt.next();
				stack.push(item);

				// key
				Object itemKey = findValue(listKey != null ? listKey : "top");
				String itemKeyStr = defs(itemKey == null ? null
						: itemKey.toString());
				// value
				Object itemValue = findValue(listValue != null ? listValue
						: "top");
				String itemValueStr = defs(itemValue == null ? null
						: itemValue.toString());

				boolean checked = ContainUtil.contains(value, itemKey);

				writeItem(name, id, itemCount, 
						itemKeyStr, itemValueStr, checked);

				stack.pop();
			}
			write("<div class=\"n-clearfix\"></div>");
		}
		else {
			write(" &nbsp;");
		}
		
		write("</div>");
	}
	
	protected void writeItem(String name, String id, int itemCount,
			String itemKeyStr, String itemValueStr, boolean checked)
			throws IOException {
		write("<span class=\"n-radio-item\">");
		Attributes ra = new Attributes();
		ra.add("type", "radio")
			.add("name", name)
			.add("id", id + "_" + itemCount)
			.cssClass(params)
			.addIfExists("value", itemKeyStr)
			.addIfTrue("checked", checked)
			.disabled(params)
			.readonly(params)
			.tabindex(params)
			.title(params)
			.cssStyle(params)
			.commons(params)
			.events(params);

		xtag("input", ra);
		
		write("<label");
		write(" for=\"");
		write(html(id) + "_" + itemCount);
		write("\" class=\"n-radio-label\">");
		body(itemValueStr);
		write("</label>");

		write("</span>");
	}
}
