/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.java.simple;

import java.io.IOException;

import org.apache.struts2.components.template.TemplateRenderingContext;

import nuts.core.lang.StringUtils;
import nuts.exts.struts2.views.java.AbstractTemplateRenderer;
import nuts.exts.struts2.views.java.Attributes;

public class NutsDateTimePickerRenderer extends AbstractTemplateRenderer {
	public NutsDateTimePickerRenderer(TemplateRenderingContext context) {
		super(context);
	}

	public void render() throws IOException {
        Attributes attr = new Attributes();

        attr.add("type", "text")
			.id(params)
			.name(params)
			.css(this, "n-datetimepicker")
			.size(params)
			.maxlength(params)
			.disabled(params)
			.readonly(params)
			.tabindex(params)
			.formatValue(this)
			.title(params)
			.commons(params)
			.events(params)
			.dynamics(params);

		xtag("input", attr);
		
		String id = defs(html((String)params.get("id")));
		String idj = defs(jsstr((String)params.get("id")));
		if (Attributes.isTrue(params.get("inline"))) {
			write("<div id=\"");
			write(id);
			write("-datetimepicker\" class=\"datetimepicker-inline\"></div>");
			
			write("<script type=\"text/javascript\">");
			write("$(function() {");
			write("var df = new DateFormat(\"");
			write((String)params.get("pattern"));
			write("\");$(\"#");
			write(idj);
			write("-datetimepicker\").datetimepicker($.extend({");
			write("dateTimeFormat: df,");
			write("defaultDateTime: df.parse($(\"#");
			write(idj);
			write("\").val()),");
			write("onSelect: function(ds, ui) {");
			write("var d = df.parse($(\"#");
			write(idj);
			write("\").val()) || new Date();");
			write("d.setFullYear(ui.getFullYear());");
			write("d.setMonth(ui.getMonth());");
			write("d.setDate(ui.getDate());");
			write("d.setHours(ui.getHours());");
			write("d.setMinutes(ui.getMinutes());");
			write("d.setSeconds(ui.getSeconds());");
			write("$(\"#");
			write(idj);
			write("\").val(df.format(d)).trigger('change');");
			write("}}, ");
			write(defs((String)params.get("defaults"), "{}"));
			write(", ");
			write(defs((String)params.get("options"), "{}"));
			write("));");
			write("$(\"#");
			write(id);
			write("\").keyup(function() {");
			write("var d = df.parse($(this).val());");
			write("if (d) { $(\"#");
			write(id);
			write("-datetimepicker\").datetimepicker('setDate', d); }");
			write("})");
			writeMask();
			write(";");
			write("});");
			write("</script>");
		}
		else {
			write("<script type=\"text/javascript\">");
			write("$(function() {");
			write("$(\"#");
			write(idj);
			write("\").datetimepicker($.extend({");
			write("buttonImage:\"");
			write(sgif());
			write("\",buttonImageOnly: true,");
			write("dateTimeFormat: new DateFormat(\"");
			write((String)params.get("pattern"));
			write("\")}, ");
			write(defs((String)params.get("defaults"), "{}"));
			write(", ");
			write(defs((String)params.get("options"), "{}"));
			write("))");
			writeMask();
			write(";");
			write("});");
			write("</script>");
		}
    }
	
	private void writeMask() throws IOException {
		String mask = (String)params.get("mask");
		if (StringUtils.isNotEmpty(mask)) {
			write(".setMask(");
			if (mask.startsWith("{")) {
				write(mask);
			}
			else {
				write("\"");
				write(mask);
				write("\"");
			}
			write(")");
		}
	}
}
