/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.views.freemarker.tags;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.opensymphony.xwork2.util.ValueStack;

/**
 * Provides @n.tag access for various tags.
 *
 */
public class NutsModels {
	protected ValueStack stack;
	protected HttpServletRequest req;
	protected HttpServletResponse res;

	protected ActionErrorModel actionerror;
	protected ActionWarningModel actionwarning;
	protected ActionConfirmModel actionconfirm;
	protected ActionMessageModel actionmessage;
	protected AnchorModel a;
	protected BooleanModel bool;
	protected ButtonModel b;
	protected CheckboxModel checkbox;
	protected CheckboxListModel checkboxList;
	protected CsvModel csv;
	protected DateModel date;
	protected DatePickerModel datepicker;
	protected DateTimePickerModel datetimepicker;
	protected FieldErrorModel fielderror;
	protected FileModel file;
	protected FormModel form;
	protected HeadModel head;
	protected HiddenModel hidden;
	protected LinkModel link;
	protected ListViewModel listview;
	protected LogModel log;
	protected NumberModel number;
	protected OptionTransferSelectModel optiontransferselect;
	protected PagerModel pager;
	protected PasswordModel password;
	protected PropertyModel property;
	protected RadioModel radio;
	protected ResetModel reset;
	protected SelectModel select;
	protected SubmitModel submit;
	protected TextModel text;
	protected TextAreaModel textarea;
	protected TextFieldModel textfield;
	protected TimePickerModel timepicker;
	protected TriggerFieldModel triggerfield;
	protected UploaderModel uploader;
	protected URLModel url;
	protected ViewFieldModel viewfield;

	/**
	 * Constructor
	 *
	 * @param stack ValueStack
	 * @param req HttpServletRequest
	 * @param res HttpServletResponse
	 */
	public NutsModels(ValueStack stack, HttpServletRequest req, HttpServletResponse res) {
		this.stack = stack;
		this.req = req;
		this.res = res;
	}

	/**
	 * @return ActionErrorModel
	 */
	public ActionErrorModel getActionerror() {
		if (actionerror == null) {
			actionerror = new ActionErrorModel(stack, req, res);
		}
		return actionerror;
	}

	/**
	 * @return ActionWarningModel
	 */
	public ActionWarningModel getActionwarning() {
		if (actionwarning == null) {
			actionwarning = new ActionWarningModel(stack, req, res);
		}
		return actionwarning;
	}

	/**
	 * @return ActionConfirmModel
	 */
	public ActionConfirmModel getActionconfirm() {
		if (actionconfirm == null) {
			actionconfirm = new ActionConfirmModel(stack, req, res);
		}
		return actionconfirm;
	}

	/**
	 * @return ActionMessageModel
	 */
	public ActionMessageModel getActionmessage() {
		if (actionmessage == null) {
			actionmessage = new ActionMessageModel(stack, req, res);
		}
		return actionmessage;
	}

	/**
	 * @return AnchorModel
	 */
	public AnchorModel getA() {
        if (a == null) {
            a = new AnchorModel(stack, req, res);
        }
        return a;
    }

	/**
	 * @return ButtonModel
	 */
	public ButtonModel getB() {
        if (b == null) {
            b = new ButtonModel(stack, req, res);
        }
        return b;
    }

	/**
	 * @return BooleanModel
	 */
	public BooleanModel getBoolean() {
		if (bool == null) {
			bool = new BooleanModel(stack, req, res);
		}
		return bool;
	}

	/**
	 * @return CheckboxModel
	 */
	public CheckboxModel getCheckbox() {
		if (checkbox == null) {
			checkbox = new CheckboxModel(stack, req, res);
		}
		return checkbox;
	}

	/**
	 * @return CsvModel
	 */
	public CsvModel getCsv() {
		if (csv == null) {
			csv = new CsvModel(stack, req, res);
		}
		return csv;
	}

	/**
	 * @return CheckboxListModel
	 */
	public CheckboxListModel getCheckboxlist() {
		if (checkboxList == null) {
			checkboxList = new CheckboxListModel(stack, req, res);
		}
		return checkboxList;
	}

	/**
	 * @return DateModel
	 */
	public DateModel getDate() {
		if (date == null) {
			date = new DateModel(stack, req, res);
		}
		return date;
	}

	/**
	 * @return DatePickerModel
	 */
	public DatePickerModel getDatepicker() {
		if (datepicker == null) {
			datepicker = new DatePickerModel(stack, req, res);
		}
		return datepicker;
	}

	/**
	 * @return DateTimePickerModel
	 */
	public DateTimePickerModel getDatetimepicker() {
		if (datetimepicker == null) {
			datetimepicker = new DateTimePickerModel(stack, req, res);
		}
		return datetimepicker;
	}

	/**
	 * @return FieldErrorModel
	 */
	public FieldErrorModel getFielderror() {
		if (fielderror == null) {
			fielderror = new FieldErrorModel(stack, req, res);
		}
		return fielderror;
	}

	/**
	 * @return FileModel
	 */
	public FileModel getFile() {
		if (file == null) {
			file = new FileModel(stack, req, res);
		}
		return file;
	}

	/**
	 * @return FormModel
	 */
	public FormModel getForm() {
		if (form == null) {
			form = new FormModel(stack, req, res);
		}
		return form;
	}

	/**
	 * @return HeadModel
	 */
	public HeadModel getHead() {
		if (head == null) {
			head = new HeadModel(stack, req, res);
		}
		return head;
	}

	/**
	 * @return HiddenModel
	 */
	public HiddenModel getHidden() {
		if (hidden == null) {
			hidden = new HiddenModel(stack, req, res);
		}
		return hidden;
	}

	/**
	 * @return LinkModel
	 */
	public LinkModel getLink() {
		if (link == null) {
			link = new LinkModel(stack, req, res);
		}
		return link;
	}

	/**
	 * @return ListViewModel
	 */
	public ListViewModel getListview() {
		if (listview == null) {
			listview = new ListViewModel(stack, req, res);
		}
		return listview;
	}

	/**
	 * @return LogModel
	 */
	public LogModel getLog() {
		if (log == null) {
			log = new LogModel(stack, req, res);
		}
		return log;
	}

	/**
	 * @return NumberModel
	 */
	public NumberModel getNumber() {
		if (number == null) {
			number = new NumberModel(stack, req, res);
		}
		return number;
	}

	/**
	 * @return OptionTransferSelectModel
	 */
	public OptionTransferSelectModel getOptiontransferselect() {
		if (optiontransferselect == null) {
			optiontransferselect = new OptionTransferSelectModel(stack, req, res);
		}
		return optiontransferselect;
	}

	/**
	 * @return PagerModel
	 */
	public PagerModel getPager() {
		if (pager == null) {
			pager = new PagerModel(stack, req, res);
		}
		return pager;
	}

	/**
	 * @return PasswordModel
	 */
	public PasswordModel getPassword() {
		if (password == null) {
			password = new PasswordModel(stack, req, res);
		}
		return password;
	}

	/**
	 * @return PropertyModel
	 */
	public PropertyModel getProperty() {
		if (property == null) {
			property = new PropertyModel(stack, req, res);
		}
		return property;
	}

	/**
	 * @return RadioModel
	 */
	public RadioModel getRadio() {
		if (radio == null) {
			radio = new RadioModel(stack, req, res);
		}
		return radio;
	}

	/**
	 * @return reset
	 */
	public ResetModel getReset() {
		if (reset == null) {
			reset = new ResetModel(stack, req, res);
		}

		return reset;
	}

	/**
	 * @return SelectModel
	 */
	public SelectModel getSelect() {
		if (select == null) {
			select = new SelectModel(stack, req, res);
		}
		return select;
	}

	/**
	 * @return submit
	 */
	public SubmitModel getSubmit() {
		if (submit == null) {
			submit = new SubmitModel(stack, req, res);
		}

		return submit;
	}

	/**
	 * @return TextModel
	 */
	public TextModel getText() {
		if (text == null) {
			text = new TextModel(stack, req, res);
		}
		return text;
	}

	/**
	 * @return TextAreaModel
	 */
	public TextAreaModel getTextarea() {
		if (textarea == null) {
			textarea = new TextAreaModel(stack, req, res);
		}
		return textarea;
	}

	/**
	 * @return TextFieldModel
	 */
	public TextFieldModel getTextfield() {
		if (textfield == null) {
			textfield = new TextFieldModel(stack, req, res);
		}
		return textfield;
	}

	/**
	 * @return TimePickerModel
	 */
	public TimePickerModel getTimepicker() {
		if (timepicker == null) {
			timepicker = new TimePickerModel(stack, req, res);
		}
		return timepicker;
	}

	/**
	 * @return TriggerFieldModel
	 */
	public TriggerFieldModel getTriggerfield() {
		if (triggerfield == null) {
			triggerfield = new TriggerFieldModel(stack, req, res);
		}
		return triggerfield;
	}

	/**
	 * @return uploaderModel
	 */
	public UploaderModel getUploader() {
		if (uploader == null) {
			uploader = new UploaderModel(stack, req, res);
		}
		return uploader;
	}

	/**
	 * @return urlModel
	 */
	public URLModel getUrl() {
		if (url == null) {
			url = new URLModel(stack, req, res);
		}
		return url;
	}

	/**
	 * @return ViewFieldModel
	 */
	public ViewFieldModel getViewfield() {
		if (viewfield == null) {
			viewfield = new ViewFieldModel(stack, req, res);
		}
		return viewfield;
	}

}
