/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.struts2.actions;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import nuts.core.io.IOUtils;
import nuts.core.lang.ExceptionUtils;
import nuts.core.net.HttpClientAgent;
import nuts.exts.struts2.util.StrutsContextUtils;

import org.apache.http.Header;

public class HttpClientAction extends CommonAction {
	private String __url;
	
	/**
	 * @return the __url
	 */
	public String get__url() {
		return __url;
	}

	/**
	 * @param __url the __url to set
	 */
	public void set__url(String __url) {
		this.__url = __url;
	}

	private void transferResponse(HttpClientAgent agent) throws Exception {
		HttpServletResponse response = StrutsContextUtils.getServletResponse();
		
		response.setStatus(agent.getResonseStatusCode());
		Header[] headers = agent.getResponseHeaders();
		for (Header h : headers) {
			if (!"Content-Encoding".equalsIgnoreCase(h.getName())) {
				response.setHeader(h.getName(), h.getValue());
			}
		}
		
		InputStream is = agent.getResponseStream();
		try {
			IOUtils.copy(is, response.getOutputStream());
		}
		finally {
			IOUtils.closeQuietly(is);
		}
	}
	
	public String doGet() {
		try {
			HttpClientAgent agent = new HttpClientAgent();
	
			agent.doGet(__url);

			transferResponse(agent);
		}
		catch (Exception e) {
			log.warn("Failed to get " + __url, e);
			sendError(e);
		}
		return NONE;
	}
	
	public String doPost() {
		try {
			HttpClientAgent agent = new HttpClientAgent();
	
			HttpServletRequest request = StrutsContextUtils.getServletRequest();
			
			Map<String, Object> params = new HashMap<String, Object>();
			for (Object o : request.getParameterMap().entrySet()) {
				Entry e = (Entry)o;
				if (e.getKey().toString().startsWith("__")) {
					continue;
				}
				params.put(e.getKey().toString(), e.getValue());
			}
			agent.doPost(__url, params);
			
			transferResponse(agent);
		}
		catch (Exception e) {
			log.warn("Failed to post " + __url, e);
			sendError(e);
		}
		return NONE;
	}

	public String doError() {
		try {
			__url.charAt(0);
		}
		catch (Exception e) {
			sendError(e);
		}
		return NONE;
	}
	
	private void sendError(Exception e) {
		String stack = ExceptionUtils.getStackTrace(e);
		HttpServletResponse response = StrutsContextUtils.getServletResponse();
		response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
		try {
			response.getWriter().write(stack);
		}
		catch (IOException e1) {
			//skip
		}
	}
	
	/**
	 * execute
	 * 
	 * @return INPUT
	 * @throws Exception if an error occurs
	 */
	public String execute() throws Exception {
		return doGet();
	}

}
