/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.exts.ibatis;

import java.util.Properties;

import javax.sql.DataSource;

import nuts.core.orm.dao.AbstractDataAccessClient;
import nuts.core.orm.dao.DataAccessException;
import nuts.core.orm.dao.DataAccessSession;

import com.ibatis.sqlmap.client.SqlMapClient;

/**
 */
public class IBatisDataAccessClient extends AbstractDataAccessClient implements SqlMapClientAware {
	private SqlMapClient sqlMapClient;
	
	/**
	 */
	public IBatisDataAccessClient() {
		super();
	}

	/**
	 * @param sqlMapClient the sqlMapClient to set
	 * @param props the props to set
	 */
	public IBatisDataAccessClient(SqlMapClient sqlMapClient, Properties props) {
		super(props);
		this.sqlMapClient = sqlMapClient;
	}

	/**
	 * @return the sqlMapClient
	 */
	public SqlMapClient getSqlMapClient() {
		return sqlMapClient;
	}

	/**
	 * @param sqlMapClient the sqlMapClient to set
	 */
	public void setSqlMapClient(SqlMapClient sqlMapClient) {
		this.sqlMapClient = sqlMapClient;
	}

	/**
	 * @return DataSource
	 */
	public DataSource getDataSource() {
		return sqlMapClient.getDataSource();
	}
	
	/**
	 * open session
	 * @param autoCommit auto commit
	 */
	public DataAccessSession openSession(boolean autoCommit) throws DataAccessException {
		return new IBatisDataAccessSession(this, autoCommit);
	}
}
