<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#--
	This template handles: 
		* intializing qTable.currentColumnCount if it has not been initialzed,
		* emiting a <tr> tag if the currentColumnCount == 0,
-->
<#if qTableLayout?exists && ! qTableLayout.currentColumnCount?exists >
	<#-- Set the currentColumnCount to 0 because this is the first row of the table. -->
	${stack.setValue('#qTableLayout.currentColumnCount', 0)}
</#if>
<#-- Do we need to write the opening tr tag. -->
<#if qTableLayout?exists && qTableLayout.tablecolspan?exists >
	<#assign columnCount = qTableLayout.currentColumnCount />
<#else>
	<#-- Set the currentColumnCount to 0 because this is the first row of the table. -->
	${stack.setValue('#qTableLayout.currentColumnCount', 0)}
	<#assign columnCount = 0 />
</#if>
<#if columnCount == 0>
	<#-- Write out the opening tr tag to start the table row. -->
	<tr><#rt/>
</#if>
