<#--
/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 http://nuts.sourceforge.jp
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#--
	This template does not support the label top position!!!

	This template handles: 
		* outputting a <td> for the label if there is one.

	Additionally it calls controlerheader-trlogic.ftl to handle table row logic.
-->
<#include "/${parameters.templateDir}/qxhtml/controlheader-trlogic.ftl" /> 
<#assign labelColumnSpan = parameters.labelcolspan!1 />
<#if parameters.label?exists>
	<td class="tdLabel" colspan="${labelColumnSpan}"><#rt/>
    <label <#t/>
	<#if parameters.id?exists>
        for="${parameters.id?html}"<#t/>
	</#if>
	<#assign hasFieldErrors = parameters.name?exists && fieldErrors?exists && fieldErrors[parameters.name]?exists/>
	<#if hasFieldErrors>
        class="errorLabel"<#t/>
	<#else>
        class="label"<#t/>
	</#if>
    ><#t/>
	<#if (parameters.required!false) && (parameters.requiredposition!"right") != 'right'>
        <span class="required">*</span><#t/>
	</#if>
	${parameters.label?html}<#t/>
	<#if (parameters.required!false) && (parameters.requiredposition!"right") == 'right'>
 		<span class="required">*</span><#t/>
	</#if>
	:<#t/>
	<#include "/${parameters.templateDir}/qxhtml/tooltip.ftl" /> 
	</label><#t/>
	</td><#lt/>
	<#-- We only update the qTableLayout.currentColumnCount if we actually printed out a td for the lable. -->
	<#if qTableLayout?exists && qTableLayout.tablecolspan?exists >
		<#assign columnCount = qTableLayout.currentColumnCount + labelColumnSpan />	
		<#-- update the value of the columnCounter.count bean on the value stack. -->
		${stack.setValue('#qTableLayout.currentColumnCount', columnCount)}
	</#if>
</#if>
