<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE sqlMap PUBLIC "-//ibatis.apache.org//DTD SQL Map 2.0//EN" "http://ibatis.apache.org/dtd/sql-map-2.dtd">

<sqlMap namespace="${model.name}">
	<!-- This file was auto-generated by ${gen.class.name} <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>. -->

	<#macro resultColumn c, p>
		<result column="${c}"<#rt/>
<#if p.jdbcType?has_content>
 jdbcType="${p.jdbcType}"<#rt/>
</#if>
<#if p.simpleJavaType?starts_with("Upload")>
 property="${p.name}.data" javaType="[B"<#rt/>
<#else>
 property="${p.name}" javaType="${p.nativeJavaType}"<#rt/>
</#if>
/>
	</#macro>
	<#macro whereByPrimaryKey>
		<#list model.primaryKeyList as p>
			${p.column} = #${p.name}:${p.jdbcType}# <#if p_has_next>AND </#if>
		</#list>
	</#macro>
	<#macro whereByPrimaryKeyA>
		<#list model.primaryKeyList as p>
			${p.column} = #${p.name}:${p.jdbcType}# <#if p_has_next>AND </#if>
		</#list>
	</#macro>

	<resultMap id="result" class="${model.modelBeanClass}">
	<#list model.columnList as p>
		<@resultColumn p.columnAlias?has_content?string(p.columnAlias!, p.column), p/>
	</#list>
	</resultMap>

	<select id="countByPrimaryKey" parameterClass="${model.modelBeanClass}" resultClass="java.lang.Integer">
		SELECT 
			COUNT(*)
		FROM 
			${model.table}
		WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="selectByPrimaryKey" resultMap="result" parameterClass="${model.modelBeanClass}">
		SELECT 
		<#list model.columnList as p>
			${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
		</#list>
		  FROM 
			${model.table}
		 WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="countByExample" parameterClass="nuts.core.orm.dao.QueryParameter" resultClass="java.lang.Integer">
		SELECT 
			COUNT(*)
		  FROM 
			${model.table}
		<include refid="Nuts.queryWhereClause"/>
	</select>

	<select id="selectByExample" resultMap="result" parameterClass="nuts.core.orm.dao.QueryParameter">
		SELECT 
		<isEqual property="hasExcludes" compareValue="false">
		<#list model.columnList as p>
			${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
		</#list>
		</isEqual>
		<isEqual property="hasExcludes" compareValue="true">
		<#list model.columnList as p>
			<isPropertyAvailable property="excludes.${p.columnAlias?has_content?string(p.columnAlias!, p.column)}">
				NULL AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
			</isPropertyAvailable>
			<isNotPropertyAvailable property="excludes.${p.columnAlias?has_content?string(p.columnAlias!, p.column)}">
				${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
			</isNotPropertyAvailable>
		</#list>
		</isEqual>
		  FROM 
			${model.table}
		<include refid="Nuts.queryClause"/>
	</select>

	<insert id="insert" parameterClass="${model.modelBeanClass}">
		INSERT 
			INTO ${model.table} (
		<#list model.columnList as p>
			${p.column}<#if p_has_next>, </#if>
		</#list>
		)
		VALUES (
		<#list model.columnList as p>
			#${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
		</#list>
		)
	<#if model.identity?has_content>
		<selectKey resultClass="${model.identityProperty.fullJavaType}" keyProperty="${model.identity}">
			SELECT @@IDENTITY
		</selectKey>
	</#if>
	</insert>

	<delete id="deleteByPrimaryKey" parameterClass="${model.modelBeanClass}">
		DELETE 
		  FROM ${model.table}
		 WHERE
			<@whereByPrimaryKeyA/>
	</delete>

	<delete id="deleteByExample" parameterClass="nuts.core.orm.dao.QueryParameter">
	<#switch dbtype?upper_case>
	<#case "MYSQL">
		DELETE 
			${model.tableAlias?has_content?string(model.tableAlias, model.table)}
		  FROM ${model.table}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	<#default>
		DELETE 
		  FROM ${model.table}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	</#switch>
	</delete>

	<update id="updateByPrimaryKey" parameterClass="${model.modelBeanClass}">
		UPDATE 
			${model.table}
		  SET
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			${p.column} = #${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
		</#if></#list>
		 WHERE
			<@whereByPrimaryKey/>
	</update>

	<update id="updateByPrimaryKeySelective" parameterClass="${model.modelBeanClass}">
		UPDATE 
			${model.table}
		<dynamic prepend="SET">
			<#list model.columnList as p><#if !(p.primaryKey!false)>
			<isNotNull prepend="," property="${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>">
				${p.column} = #${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#
			</isNotNull>
			</#if></#list>
		</dynamic>
		 WHERE
			<@whereByPrimaryKey/>
	</update>

	<update id="updateByExample" parameterClass="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE 
			${model.table}
		  SET
		<isEqual property="hasExcludes" compareValue="false">
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
		</#if></#list>
		</isEqual>
		<isEqual property="hasExcludes" compareValue="true">
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			<isNotPropertyAvailable property="excludes.${p.columnAlias?has_content?string(p.columnAlias!, p.column)}">
				${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
			</isNotPropertyAvailable>				
		</#if></#list>
		</isEqual>
		<include refid="Nuts.queryWhereClause"/>
	</update>

	<update id="updateByExampleSelective" parameterClass="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE 
			${model.table}
		<dynamic prepend="SET">
			<#list model.columnList as p><#if !(p.primaryKey!false)>
			<isNotNull prepend="," property="data.${p.name}">
				${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#
			</isNotNull>
			</#if></#list>
		</dynamic>
		<include refid="Nuts.queryWhereClause"/>
	</update>
</sqlMap>
