<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE sqlMap PUBLIC "-//ibatis.apache.org//DTD SQL Map 2.0//EN" "http://ibatis.apache.org/dtd/sql-map-2.dtd">

<!-- This file was auto-generated by ${gen.class.name} <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>. -->

<sqlMap namespace="${model.name}">
	<#macro resultColumn c, p>
		<result column="${c}"<#rt/>
<#if p.jdbcType?has_content>
 jdbcType="${p.jdbcType}"<#rt/>
</#if>
<#if p.simpleJavaType?starts_with("Upload")>
 property="${p.name}.data" javaType="[B"<#rt/>
<#else>
 property="${p.name}" javaType="${p.nativeJavaType}"<#rt/>
</#if>
/>
	</#macro>
	<#macro nullValue p>
		<#switch dbtype?upper_case>
		<#case "ORACLE">
			<#switch p.jdbcType!>
			<#case "BLOB">
				TO_BLOB(NULL)<#t/>
				<#break>
			<#case "CLOB">
				TO_CLOB(NULL)<#t/>
				<#break>
			<#default>
				NULL<#t/>
				<#break>
			</#switch>
			<#break>
		<#default>
			NULL<#t/>
			<#break>
		</#switch>
	</#macro>
	<#macro fromWithJoins>
			${model.table} ${model.asTableAlias}
			<#list model.joinConditionList as p>
				${p.joinType?upper_case} JOIN ${p.joinTable} ${p.joinTableAlias!} ON (${p.joinCondition?html})
			</#list>
	</#macro>
	<#macro whereByPrimaryKey>
		<#list model.primaryKeyList as p>
			${model.tableOrAlias}.${p.column} = #${p.name}:${p.jdbcType}# <#if p_has_next>AND </#if>
		</#list>
	</#macro>
	<#macro whereByPrimaryKeyU>
		<#list model.primaryKeyList as p>
			${p.column} = #${p.name}:${p.jdbcType}# <#if p_has_next>AND </#if>
		</#list>
	</#macro>

	<resultMap id="result" class="${model.modelBeanClass}">
	<#list model.columnList as p>
		<@resultColumn p.columnAlias?has_content?string(p.columnAlias!, p.column), p/>
	</#list>
	<#list model.joinColumnList as p>
		<@resultColumn p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn), p/>
	</#list>
	<#list model.sqlExpressionList as p>
		<@resultColumn p.columnAlias, p/>
	</#list>
	</resultMap>

	<select id="countByPrimaryKey" parameterClass="${model.modelBeanClass}" resultClass="java.lang.Integer">
		SELECT /* ${model.name}.countByPrimaryKey */
			COUNT(1)
		FROM 
			${model.table} ${model.asTableAlias}
		WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="selectByPrimaryKey" resultMap="result" parameterClass="${model.modelBeanClass}">
		SELECT /* ${model.name}.selectByPrimaryKey */
		<#list model.columnList as p>
			${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
		</#list>
		<#list model.joinColumnList as p>
			, ${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}
		</#list>
		<#list model.sqlExpressionList as p>
			, ${p.sqlExpression?html} AS ${p.columnAlias}
		</#list>
		  FROM 
			<@fromWithJoins/>
		 WHERE
			<@whereByPrimaryKey/>
	</select>

	<select id="countByExample" parameterClass="nuts.core.orm.dao.QueryParameter" resultClass="java.lang.Integer">
		SELECT /* ${model.name}.countByExample */
			COUNT(1)
		  FROM 
			<@fromWithJoins/>
		<include refid="Nuts.queryWhereClause"/>
	</select>

	<select id="selectByExample" resultMap="result" parameterClass="nuts.core.orm.dao.QueryParameter">
		SELECT /* ${model.name}.selectByExample */
		<dynamic prepend=" ">
			<isEqual property="hasExcludes" compareValue="false">
			<#list model.columnList as p>
				${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}<#if p_has_next>, </#if>
			</#list>
			<#list model.joinColumnList as p>
				, ${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}
			</#list>
			<#list model.sqlExpressionList as p>
				, ${p.sqlExpression?html} AS ${p.columnAlias}
			</#list>
			</isEqual>
			<isEqual property="hasExcludes" compareValue="true">
			<#list model.columnList as p>
				<isPropertyAvailable prepend="," property="excludes.${p.name}">
					<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}
				</isPropertyAvailable>
				<isNotPropertyAvailable prepend="," property="excludes.${p.name}">
					${model.tableOrAlias}.${p.column} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.column)}
				</isNotPropertyAvailable>				
			</#list>
			<#list model.joinColumnList as p>
				<isPropertyAvailable prepend="," property="excludes.${p.name}">
					<@nullValue p/> AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}
				</isPropertyAvailable>
				<isNotPropertyAvailable prepend="," property="excludes.${p.name}">
					${p.joinTableAlias?has_content?string(p.joinTableAlias!, p.joinTable)}.${p.joinColumn} AS ${p.columnAlias?has_content?string(p.columnAlias!, p.joinColumn)}
				</isNotPropertyAvailable>				
			</#list>
			<#list model.sqlExpressionList as p>
				<isPropertyAvailable prepend="," property="excludes.${p.name}">
					<@nullValue p/> AS ${p.columnAlias}
				</isPropertyAvailable>
				<isNotPropertyAvailable prepend="," property="excludes.${p.name}">
					${p.sqlExpression?html} AS ${p.columnAlias}
				</isNotPropertyAvailable>
			</#list>
			</isEqual>
		</dynamic>
		  FROM 
			<@fromWithJoins/>
		<include refid="Nuts.queryClause"/>
	</select>

	<#macro selectKey sql>
		<selectKey resultClass="${model.identityProperty.fullJavaType}" keyProperty="${model.identity}">
			${sql}
		</selectKey>
	</#macro>
	<insert id="insert" parameterClass="${model.modelBeanClass}">
	<#if model.identity?has_content>
		<#switch dbtype?upper_case>
		<#case "ORACLE">
			<@selectKey sql="SELECT " + model.identitySequence!(model.table + "_SEQ") + ".NEXTVAL FROM DUAL" />
			<#break>
		<#case "POSTGRE">
			<#list model.columnList as p><#if model.identity == p.name>
			<@selectKey sql="SELECT NEXTVAL('" + (model.table + "_" + p.column + "_SEQ") + "')" />
			</#if></#list>
			<#break>
		</#switch>
	</#if>
		INSERT /* ${model.name}.insert */
			INTO ${model.table} (
		<#list model.columnList as p>
			${p.column}<#if p_has_next>, </#if>
		</#list>
		)
		VALUES (
		<#list model.columnList as p>
			#${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
		</#list>
		)
	<#if model.identity?has_content>
		<#switch dbtype?upper_case>
		<#case "CLOUDSCAPE">
			<@selectKey sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "DB2">
			<@selectKey sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "DB2_MF">
			<@selectKey sql="VALUES SELECT IDENTITY_VAL_LOCAL() FROM SYSIBM.SYSDUMMY1" />
			<#break>
		<#case "DERBY">
			<@selectKey sql="VALUES IDENTITY_VAL_LOCAL()" />
			<#break>
		<#case "HSQLDB">
			<@selectKey sql="CALL IDENTITY()" />
			<#break>
		<#case "MYSQL">
			<@selectKey sql="SELECT LAST_INSERT_ID()" />
			<#break>
		<#case "SQLSERVER">
			<@selectKey sql="SELECT SCOPE_IDENTITY()" />
			<#break>
		<#case "SYBASE">
			<@selectKey sql="SELECT @@IDENTITY" />
			<#break>
		</#switch>
	</#if>
	</insert>

	<delete id="deleteByPrimaryKey" parameterClass="${model.modelBeanClass}">
		DELETE /* ${model.name}.deleteByPrimaryKey */
		  FROM ${model.table}
		 WHERE
			<@whereByPrimaryKeyU/>
	</delete>

	<delete id="deleteByExample" parameterClass="nuts.core.orm.dao.QueryParameter">
	<#switch dbtype?upper_case>
	<#case "MYSQL">
		DELETE /* ${model.name}.deleteByExample */
			${model.tableOrAlias}
		  FROM ${model.table} ${model.asTableAlias}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	<#default>
		DELETE /* ${model.name}.deleteByExample */
		  FROM ${model.table} ${model.asTableAlias}
		<include refid="Nuts.queryWhereClause"/>
		<#break>
	</#switch>
	</delete>

	<update id="updateByPrimaryKey" parameterClass="${model.modelBeanClass}">
		UPDATE /* ${model.name}.updateByPrimaryKey */
			${model.table}
		  SET
		<#list model.columnList as p><#if !(p.primaryKey!false)>
			${p.column} = #${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
		</#if></#list>
		 WHERE
			<@whereByPrimaryKeyU/>
	</update>

	<update id="updateByPrimaryKeySelective" parameterClass="${model.modelBeanClass}">
		UPDATE /* ${model.name}.updateByPrimaryKeySelective */
			${model.table}
		<dynamic prepend="SET">
			<#list model.columnList as p><#if !(p.primaryKey!false)>
			<isNotNull prepend="," property="${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>">
				${p.column} = #${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#
			</isNotNull>
			</#if></#list>
		</dynamic>
		 WHERE
			<@whereByPrimaryKeyU/>
	</update>

	<update id="updateByExample" parameterClass="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE /* ${model.name}.updateByExampleExclude */
			${model.table} ${model.asTableAlias}
		<dynamic prepend="SET">
			<isEqual property="hasExcludes" compareValue="false">
			<#list model.columnList as p><#if !(p.primaryKey!false)>
				${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#<#if p_has_next>, </#if>
			</#if></#list>
			</isEqual>
			<isEqual property="hasExcludes" compareValue="true">
				<#list model.columnList as p><#if !(p.primaryKey!false)>
					<isNotPropertyAvailable prepend="," property="excludes.${p.name}">
						${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#
					</isNotPropertyAvailable>				
				</#if></#list>
			</isEqual>
		</dynamic>
		<include refid="Nuts.queryWhereClause"/>
	</update>

	<update id="updateByExampleSelective" parameterClass="nuts.core.sql.criterion.SqlUpdateParameter">
		UPDATE /* ${model.name}.updateByExampleSelective */
			${model.table} ${model.asTableAlias}
		<dynamic prepend="SET">
			<#list model.columnList as p><#if !(p.primaryKey!false)>
			<isNotNull prepend="," property="data.${p.name}">
				${p.column} = #data.${p.name}<#if p.simpleJavaType?starts_with("Upload")>.data</#if>:${p.jdbcType}#
			</isNotNull>
			</#if></#list>
		</dynamic>
		<include refid="Nuts.queryWhereClause"/>
	</update>
</sqlMap>
