<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
<#include "../ModelExampleRestrict.ftl"/>
package ${modelExamplePackage};

<#list imports as i>
import ${i};
</#list>

/**
 * ${modelExampleClass}
 *
 * This class was auto-generated by ${gen.class.name}
 * <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>
 */
public class ${modelExampleClass} extends ${class_name(model.baseExampleClass)} {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = ${svuid?c}L;

	/**
	 * Constructor
	 */
	public ${modelExampleClass}() {
		super();
		setQuery(new Query(${modelMetaDataClass}.TABLE_NAME));
	}

	/**
	 * append AND
	 * @return this
	 */
	public ${modelExampleClass} and() {
		getConditions().and();
		return this;
	}

	//----------------------------------------------------------------------
	// ALL exclude & include
	//----------------------------------------------------------------------
	/**
	 * excludeALL
	 * @return this
	 */
	public ${modelExampleClass} excludeALL() {
<#list model.columnList as p>
		${p.name}().exclude();
</#list>
		return this;
	}

	/**
	 * includeALL
	 * @return this
	 */
	public ${modelExampleClass} includeALL() {
		clearExcludes();
		return this;
	}

	//----------------------------------------------------------------------
	// column restrictions
	//----------------------------------------------------------------------
<#list model.columnList as p>
	<@restrict p=p 
			cn=model.tableAlias?has_content?string(model.tableAlias!, model.table) + "_" + p.column
			ca=p.columnAlias?has_content?string(p.columnAlias!, p.column) />
</#list>
}

