<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
package ${modelDaoPackage};

<#list imports as i>
import ${i};
</#list>

/**
 * ${modelDaoClass}
 *
 * This class was auto-generated by ${gen.class.name}
 * <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>
 */
public class ${modelDaoClass} extends ${class_name(model.baseDaoClass)}<${modelBeanClass}, ${modelExampleClass}> {

	/**
	 * Constructor
	 *
	 * @param daoClient the daoClient to set
	 */
	public ${modelDaoClass}() {
		super();
	}

	/**
	 * Constructor
	 *
	 * @param daoSession the daoSession to set
	 */
	public ${modelDaoClass}(DaoSession daoSession) {
		super(daoSession);
	}

	/**
	 * create example
	 * @return example instance
	 */
	public ${modelExampleClass} createExample() {
		return new ${modelExampleClass}();
	}

	/**
	 * @return model id
	 */
	protected String getModelId() {
		return ${modelMetaDataClass}.TABLE_NAME;
	}
	
	/**
	 * exists
	 * 
	<#list model.primaryKeyList as p>
	 * @param ${p.name} ${p.name}
	</#list>
	 * @return true if exists
	 * @throws DaoException if a data access error occurs
	 */ 
	public boolean exists(<#list model.primaryKeyList as p>${p.simpleJavaType} ${p.name}<#if p_has_next>, </#if></#list>) throws DaoException {
		${modelBeanClass} key = new ${modelBeanClass}();
<#list model.primaryKeyList as p>
		key.set${p.name?cap_first}(${p.name});
</#list>
		return exists(key);
	}
	
	/**
	 * fetch
	 * 
	<#list model.primaryKeyList as p>
	 * @param ${p.name} ${p.name}
	</#list>
	 * @return ${modelBeanClass}
	 * @throws DaoException if a data access error occurs
	 */ 
	public ${modelBeanClass} fetch(<#list model.primaryKeyList as p>${p.simpleJavaType} ${p.name}<#if p_has_next>, </#if></#list>) throws DaoException {
		${modelBeanClass} key = new ${modelBeanClass}();
<#list model.primaryKeyList as p>
		key.set${p.name?cap_first}(${p.name});
</#list>
		return fetch(key);
	}

	/**
	 * delete
	 * 
	<#list model.primaryKeyList as p>
	 * @param ${p.name} ${p.name}
	</#list>
	 * @return count of deleted records
	 * @throws DaoException if a data access error occurs
	 */ 
	public int delete(<#list model.primaryKeyList as p>${p.simpleJavaType} ${p.name}<#if p_has_next>, </#if></#list>) throws DaoException {
		${modelBeanClass} key = new ${modelBeanClass}();
<#list model.primaryKeyList as p>
		key.set${p.name?cap_first}(${p.name});
</#list>
		return delete(key);
	}
}
