<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "common.ftl"/>
package ${modelBeanPackage};

<#list imports as i>
import ${i};
</#list>

/**
 * ${modelBeanClass}
 *
 * This class was auto-generated by ${gen.class.name}
 * <#if date??>(${date?string("yyyy-MM-dd HH:mm:ss")})</#if>
 */
public class ${modelBeanClass} <#if model.baseBeanClass?has_content>extends ${class_name(model.baseBeanClass)} </#if>{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = ${svuid?c}L;

	/**
	 * Constructor
	 */
	public ${modelBeanClass}() {
		super();
	}

	/*----------------------------------------------------------------------*
	 * Properties
	 *----------------------------------------------------------------------*/
<#list model.orgPropertyList as p>
	protected ${p.simpleJavaType} ${p.name}<#if p.initValue?has_content> = ${p.initValue}</#if>;
</#list>

<#list model.orgPropertyList as p>
	/**
	 * @return the ${p.name}
	 */
	public ${p.simpleJavaType} get${p.name?cap_first}() {
	<#assign getterTrim = "" />
	<#if p.getterTrim??>
		<#if p.getterTrim?has_content>
			<#assign getterTrim = p.getterTrim/>
		</#if>
	</#if>
	<#if p.getterCode?has_content>
		${p.getterCode}
	<#elseif getterTrim?has_content>
		return ${getterTrim}(${p.name});
	<#else>
		return ${p.name};
	</#if>
	}

	/**
	 * @param ${p.name} the ${p.name} to set
	 */
	public void set${p.name?cap_first}(${p.simpleJavaType} ${p.name}) {
	<#assign setterTrim = "" />
	<#if p.setterTrim??>
		<#if p.setterTrim?has_content>
			<#assign setterTrim = p.setterTrim/>
		</#if>
	<#elseif model.trimString?has_content && p.simpleJavaType == "String">
		<#assign setterTrim = model.trimString />
	</#if>
	<#if p.setterCode?has_content>
		${p.setterCode}
	<#elseif setterTrim?has_content>
		this.${p.name} = ${setterTrim}(${p.name});
	<#else>
		this.${p.name} = ${p.name};
	</#if>
	}

</#list>

	/**
	 * set properties from the specified object.
	 */
	public void set(${modelBeanClass} src) {
<#list model.propertyList as p>
		this.${p.name} = src.${p.name};
</#list>
	}

	/**
	 * Creates and returns a copy of this object.
	 * @return the copy object
	 */
	@Override
	public ${modelBeanClass} clone() {
		${modelBeanClass} copy = new ${modelBeanClass}();
		
		copy.set(this);

		return copy;
	}

	/**
     * @return  a hash code value for this object.
	 */
	@Override
	public int hashCode() {
<#if model.primaryKeyList?size == 1>
		return ${model.primaryKeyList[0].name} == null ? 0 : ${model.primaryKeyList[0].name}.hashCode();
<#else>
		final int prime = 31;
		int result = 1;
	<#list model.primaryKeyList as p>
		result = prime * result + ((${p.name} == null) ? 0 : ${p.name}.hashCode());
	</#list>
		return result;
</#if>
	}

	/**
     * @return  <code>true</code> if this object is the same as the obj argument; 
     * 			<code>false</code> otherwise.
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
<#if 'false' == props['model.equals.pkey']!'true'>
	<#assign pl = model.propertyList/>
<#else>
	<#assign pl = model.primaryKeyList/>
</#if>		

		${modelBeanClass} other = (${modelBeanClass})obj;
	<#list pl as p>
		if (${p.name} == null) {
			if (other.${p.name} != null) {
				return false;
			}
		}
		else if (!${p.name}.equals(other.${p.name})) {
			return false;
		}
	</#list>

		return true;
	}

	/**
     * @return  a string representation of the object.
	 */
	@Override
	public String toString() {
		if (CycleDetector.contains(this)) {
			return super.toString();
		}
		
		CycleDetector.push(this);
		try {
			StringBuilder sb = new StringBuilder();

			sb.append("{ ");
	<#list model.propertyList as p>
		<#if p.fullJavaType?starts_with("java.")>
			sb.append("${p.name}: ").append(${p.name})<#if p_has_next>.append(", ")</#if>;
		<#else>
			sb.append("${p.name}: { ").append(${p.name}).append(" }")<#if p_has_next>.append(", ")</#if>;
		</#if>
	</#list>
			sb.append(" }");

			return sb.toString();
		}
		finally {
			CycleDetector.pop();
		}
	}
}

