<#--
/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
-->
<#include "../common.ftl"/>
<#assign tbn = gen.escapeTableName(model.table) />
CREATE TABLE ${tbn} (
<#list model.columnList as p>
<#if (model.identity!) == p.name>
	${gen.escapeColumnName(p.column)} <#if p.nativeType == 'BIGINT'>BIG</#if>SERIAL PRIMARY KEY<#rt/>
		<#lt/><#if p_has_next>, </#if>
<#else>
	${gen.escapeColumnName(p.column)} ${p.nativeType}<#rt/>
		<#lt/><#if p.size?has_content>(${p.size})</#if><#rt/>
		<#lt/><#if p.notNull!false> NOT</#if> NULL<#rt/>
		<#lt/><#if p.defaultValue?has_content> DEFAULT ${p.defaultValue}</#if><#rt/>
		<#lt/><#if p_has_next>, </#if>
</#if>
</#list>
);
<#if model.identity?has_content>
	ALTER SEQUENCE ${tbn}_${model.identity}_SEQ RESTART WITH ${(model.identityStart!1)?c};
</#if>
<#if model.label?has_content>
	COMMENT ON TABLE ${tbn} IS '${model.label}';
</#if>
<#list model.columnList as p><#if p.label?has_content>
	COMMENT ON COLUMN ${gen.escapeTableColumnName(model.table, p.column)} IS '${p.label}';
</#if></#list>

