/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.poi.xls;

import nuts.tools.poi.ESummary;

import java.util.LinkedHashMap;
import java.util.Map;

public class EWorkbook {
	private ESummary summary;
	private Map<Integer, ESheet> sheets = new LinkedHashMap<Integer, ESheet>();

	/**
	 * @return the summary
	 */
	public ESummary getSummary() {
		return summary;
	}

	/**
	 * @param summary the summary to set
	 */
	public void setSummary(ESummary summary) {
		this.summary = summary;
	}

	/**
	 * @return the sheets
	 */
	public Map<Integer, ESheet> getSheets() {
		return sheets;
	}

	/**
	 * @param sheets the sheets to set
	 */
	public void setSheets(Map<Integer, ESheet> sheets) {
		this.sheets = sheets;
	}
}

