/*
 * This file is part of Nuts Framework.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.tools.poi.ppt;

import java.util.LinkedHashMap;
import java.util.Map;



public class ESlide {
	private EHeaderFooter header;
	private Map<String, EComment> comments = new LinkedHashMap<String, EComment>();
	private Map<String, String> texts = new LinkedHashMap<String, String>();
	private Map<String, String> notes = new LinkedHashMap<String, String>();
	
	/**
	 * @return the header
	 */
	public EHeaderFooter getHeader() {
		return header;
	}
	/**
	 * @param header the header to set
	 */
	public void setHeader(EHeaderFooter header) {
		this.header = header;
	}
	/**
	 * @return the comments
	 */
	public Map<String, EComment> getComments() {
		return comments;
	}
	/**
	 * @param comments the comments to set
	 */
	public void setComments(Map<String, EComment> comments) {
		this.comments = comments;
	}
	/**
	 * @return the texts
	 */
	public Map<String, String> getTexts() {
		return texts;
	}
	/**
	 * @param texts the texts to set
	 */
	public void setTexts(Map<String, String> texts) {
		this.texts = texts;
	}
	/**
	 * @return the notes
	 */
	public Map<String, String> getNotes() {
		return notes;
	}
	/**
	 * @param notes the notes to set
	 */
	public void setNotes(Map<String, String> notes) {
		this.notes = notes;
	}

}
